/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.login.InMemoryUserDetails;
import cloud.agileframework.spring.util.ServletUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class InMemoryUserDetailsServiceImpl
implements CustomerUserDetailsService {
    @Autowired
    private AuthenticationManager authenticationManager;
    private final Map<String, InMemoryUserDetails> cache = Maps.newHashMap();

    @Override
    public void validate(UserDetails securityUser) throws AuthenticationException {
        if (!securityUser.isAccountNonExpired()) {
            throw new AccountExpiredException(securityUser.getUsername());
        }
        if (!securityUser.isAccountNonLocked()) {
            throw new LockedException(securityUser.getUsername());
        }
        if (!securityUser.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException(securityUser.getUsername());
        }
        if (!securityUser.isEnabled()) {
            throw new BadCredentialsException(securityUser.getUsername());
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        HttpServletRequest request = ServletUtil.getCurrentRequest();
        String springSecurityCurrentUser = "SPRING_SECURITY_CURRENT_USER";
        UserDetails user = (UserDetails)request.getAttribute("SPRING_SECURITY_CURRENT_USER");
        if (user == null) {
            user = this.cache.get(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        request.setAttribute("SPRING_SECURITY_CURRENT_USER", (Object)user);
        return user;
    }

    public void createUser(UserDetails user) {
        this.updateUser(user);
    }

    public void updateUser(UserDetails user) {
        this.cache.put(user.getUsername(), InMemoryUserDetails.of(user));
    }

    public void deleteUser(String username) {
        this.cache.remove(username);
    }

    public void changePassword(String oldPassword, String newPassword) {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            throw new AccessDeniedException("Can't change password as no Authentication object found in context for current user.");
        }
        String username = currentUser.getName();
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)oldPassword));
        InMemoryUserDetails user = this.cache.get(username);
        if (user == null) {
            throw new IllegalStateException("Current user doesn't exist in database.");
        }
        user.setPassword(newPassword);
    }

    public boolean userExists(String username) {
        return this.cache.get(username) != null;
    }
}

