/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.logout;

import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.token.CurrentLoginInfo;
import cloud.agileframework.security.filter.token.LoginCacheInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.LogoutProcessorProvider;
import cloud.agileframework.spring.util.ParamUtil;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.event.LogoutSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class TokenCleanLogoutHandler
implements LogoutHandler,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LOGOUT_USERNAME = "SPRING_SECURITY_LOGOUT_USERNAME";
    public static final String LOGOUT_TOKEN = "SPRING_SECURITY_LOGOUT_TOKEN";
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private CustomerUserDetailsService securityUserDetailsService;
    @Autowired
    private ObjectProvider<LogoutProcessorProvider> observers;
    private ApplicationContext applicationContext;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String token = ParamUtil.getInfo((HttpServletRequest)request, (String)this.securityProperties.getTokenHeader());
        if (token == null) {
            return;
        }
        CurrentLoginInfo currentLoginInfo = LoginCacheInfo.getCurrentLoginInfo(token);
        String username = currentLoginInfo.getLoginCacheInfo().getUsername();
        String sessionToken = Long.toString(currentLoginInfo.getSessionToken());
        request.setAttribute(LOGOUT_USERNAME, (Object)username);
        request.setAttribute(LOGOUT_TOKEN, (Object)token);
        this.securityUserDetailsService.stopLoginInfo(username, sessionToken);
        LoginCacheInfo.remove(currentLoginInfo);
        this.cleanHeader(response);
        this.cleanCookie(request, response);
        this.after(username, token);
        this.applicationContext.publishEvent((ApplicationEvent)new LogoutSuccessEvent(authentication));
        this.logger.info(String.format("\u8d26\u53f7\u9000\u51fa[username:%s][token\uff1a%s]", username, sessionToken));
    }

    private void cleanHeader(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(this.securityProperties.getTokenHeader(), "");
    }

    private void cleanCookie(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return;
        }
        Optional<Cookie> cookieOptional = Arrays.stream(cookies).filter(cookie -> cookie.getName().equalsIgnoreCase(this.securityProperties.getTokenHeader())).findFirst();
        if (!cookieOptional.isPresent()) {
            return;
        }
        Cookie cookie2 = cookieOptional.get();
        cookie2.setValue(null);
        cookie2.setHttpOnly(true);
        cookie2.setMaxAge(0);
        cookie2.setPath("/");
        httpServletResponse.addCookie(cookie2);
    }

    private void after(String username, String token) {
        this.observers.stream().forEach(node -> {
            try {
                node.after(username, token);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

