/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.simulation;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.security.properties.SimulationProperties;
import cloud.agileframework.spring.util.SecurityUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.OncePerRequestFilter;

public class SimulationFilter
extends OncePerRequestFilter {
    private final SimulationProperties simulationProperties;

    public SimulationFilter(SimulationProperties simulationProperties) {
        this.simulationProperties = simulationProperties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null && this.simulationProperties.isEnable()) {
            UserDetails user = (UserDetails)ObjectUtil.to((Object)this.simulationProperties.getUser(), (TypeReference)new TypeReference(this.simulationProperties.getUserClass()));
            if (user == null) {
                throw new RuntimeException("\u6a21\u62df\u8d26\u6237\u6570\u636euser\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807userClass\u7c7b\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9");
            }
            authentication = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        SecurityUtil.setCurrentUser((HttpServletRequest)request, (Authentication)authentication);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

