/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.token;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.security.exception.NoSignInException;
import cloud.agileframework.security.exception.TokenIllegalException;
import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.token.CurrentLoginInfo;
import cloud.agileframework.security.filter.token.TokenInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.util.TokenUtil;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.IdUtil;
import cloud.agileframework.spring.util.ServletUtil;
import eu.bitwalker.useragentutils.UserAgent;
import eu.bitwalker.useragentutils.Version;
import io.jsonwebtoken.Claims;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LoginCacheInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private Authentication authentication;
    private Map<Long, TokenInfo> sessionTokens = new HashMap<Long, TokenInfo>();
    private static SecurityProperties securityProperties = (SecurityProperties)BeanUtil.getBean(SecurityProperties.class);
    public static final String LOGIN_USER_PREFIX = "LOGIN_USER_";
    private static AgileCache cache = CacheUtil.getCache((String)((SecurityProperties)Objects.requireNonNull(BeanUtil.getBean(SecurityProperties.class))).getTokenHeader());
    private static CustomerUserDetailsService customerUserDetailsService = (CustomerUserDetailsService)BeanUtil.getBean(CustomerUserDetailsService.class);

    public static AgileCache getCache() {
        return cache;
    }

    public static LoginCacheInfo createLoginCacheInfo(String username, Authentication authentication, Long sessionToken, TokenInfo tokenInfo) {
        Map<Long, TokenInfo> sessionTokens;
        LoginCacheInfo loginCacheInfo = (LoginCacheInfo)cache.get((Object)(LOGIN_USER_PREFIX + username), LoginCacheInfo.class);
        if (loginCacheInfo == null) {
            loginCacheInfo = new LoginCacheInfo();
            loginCacheInfo.setUsername(username);
            loginCacheInfo.setAuthentication(authentication);
            sessionTokens = new HashMap<Long, TokenInfo>(1);
        } else {
            loginCacheInfo.setUsername(username);
            loginCacheInfo.setAuthentication(authentication);
            sessionTokens = loginCacheInfo.getSessionTokens();
            LoginCacheInfo.parsingTimeOut(sessionTokens);
        }
        sessionTokens.put(sessionToken, tokenInfo);
        loginCacheInfo.setSessionTokens(sessionTokens);
        return loginCacheInfo;
    }

    public static TokenInfo createTokenInfo(String token, Date start, Date end) {
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setToken(token);
        tokenInfo.setStart(start);
        tokenInfo.setEnd(end);
        tokenInfo.setIp(ServletUtil.getRequestIP((HttpServletRequest)ServletUtil.getCurrentRequest()));
        UserAgent userAgent = UserAgent.parseUserAgentString((String)ServletUtil.getCurrentRequest().getHeader("User-Agent"));
        tokenInfo.setBrowser(userAgent.getBrowser());
        Version version = userAgent.getBrowserVersion();
        tokenInfo.setBrowserVersion(version == null ? null : version.getVersion());
        tokenInfo.setOs(userAgent.getOperatingSystem());
        return tokenInfo;
    }

    public void parsingTimeOut() {
        LoginCacheInfo.parsingTimeOut(this.sessionTokens);
    }

    private static synchronized void parsingTimeOut(Map<Long, TokenInfo> sessionTokens) {
        if (sessionTokens == null) {
            return;
        }
        Collection<TokenInfo> values = sessionTokens.values();
        Iterator<TokenInfo> it = values.iterator();
        while (it.hasNext()) {
            TokenInfo tokenInfo = it.next();
            if (tokenInfo.getEnd().after(DateUtil.getCurrentDate())) continue;
            it.remove();
        }
    }

    public static CurrentLoginInfo getCurrentLoginInfo(String token) {
        if (StringUtil.isBlank((CharSequence)token)) {
            throw new NoSignInException("\u8d26\u53f7\u5c1a\u672a\u767b\u5f55");
        }
        Claims claims = TokenUtil.getClaimsFromToken(token);
        if (claims == null) {
            throw new TokenIllegalException("\u8eab\u4efd\u4ee4\u724c\u9a8c\u8bc1\u5931\u8d25");
        }
        return LoginCacheInfo.refreshTimeOut(claims);
    }

    public static String refreshToken(CurrentLoginInfo currentLoginInfo) {
        LoginCacheInfo loginCacheInfo = currentLoginInfo.getLoginCacheInfo();
        Long oldSessionToken = currentLoginInfo.getSessionToken();
        long newSessionToken = IdUtil.generatorId();
        loginCacheInfo.getSessionTokens().remove(oldSessionToken);
        String token = TokenUtil.generateToken(currentLoginInfo.getLoginCacheInfo().getUsername(), newSessionToken, DateUtil.add((Date)new Date(), (Duration)Duration.of(365L, ChronoUnit.DAYS)));
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setToken(token);
        tokenInfo.setStart(new Date());
        tokenInfo.setEnd(DateUtil.add((Date)new Date(), (Duration)securityProperties.getTokenTimeout()));
        loginCacheInfo.getSessionTokens().put(newSessionToken, tokenInfo);
        UserAgent userAgent = UserAgent.parseUserAgentString((String)ServletUtil.getCurrentRequest().getHeader("User-Agent"));
        tokenInfo.setBrowser(userAgent.getBrowser());
        tokenInfo.setBrowserVersion(userAgent.getBrowserVersion().getVersion());
        tokenInfo.setOs(userAgent.getOperatingSystem());
        cache.put((Object)(LOGIN_USER_PREFIX + loginCacheInfo.getUsername()), (Object)loginCacheInfo);
        CustomerUserDetailsService securityUserDetailsService = (CustomerUserDetailsService)BeanUtil.getBean(CustomerUserDetailsService.class);
        assert (securityUserDetailsService != null);
        securityUserDetailsService.updateLoginInfo(loginCacheInfo.getUsername(), Long.toString(oldSessionToken), Long.toString(newSessionToken));
        return token;
    }

    public static void validateCacheDate(LoginCacheInfo loginCacheInfo) {
        LoginCacheInfo info = Optional.ofNullable(loginCacheInfo).orElseThrow(() -> new UsernameNotFoundException("Not Found Account"));
        customerUserDetailsService.validate((UserDetails)info.getAuthentication().getPrincipal());
    }

    private static CurrentLoginInfo refreshTimeOut(Claims claims) {
        Long sessionToken = (Long)claims.get("AUTHENTICATION_SESSION_TOKEN", Long.class);
        String username = (String)claims.get("AUTHENTICATION_USER_NAME", String.class);
        LoginCacheInfo loginCacheInfo = (LoginCacheInfo)cache.get((Object)(LOGIN_USER_PREFIX + username), LoginCacheInfo.class);
        if (loginCacheInfo == null) {
            throw new TokenIllegalException("\u65e0\u6548\u8eab\u4efd\u4ee4\u724c");
        }
        loginCacheInfo.parsingTimeOut();
        TokenInfo sessionInfo = loginCacheInfo.getSessionTokens().get(sessionToken);
        if (sessionInfo == null) {
            throw new TokenIllegalException("\u8eab\u4efd\u4ee4\u724c\u5df2\u8fc7\u671f");
        }
        if (!claims.getExpiration().after(DateUtil.getCurrentDate())) {
            throw new TokenIllegalException("\u8eab\u4efd\u4ee4\u724c\u5df2\u8fc7\u671f");
        }
        sessionInfo.setEnd(DateUtil.add((Date)new Date(), (Duration)securityProperties.getTokenTimeout()));
        cache.put((Object)(LOGIN_USER_PREFIX + username), (Object)loginCacheInfo);
        return new CurrentLoginInfo(sessionToken, loginCacheInfo);
    }

    public static void remove(String token) {
        LoginCacheInfo.remove(LoginCacheInfo.getCurrentLoginInfo(token));
    }

    public static void remove(CurrentLoginInfo currentLoginInfo) {
        currentLoginInfo.getLoginCacheInfo().getSessionTokens().remove(currentLoginInfo.getSessionToken());
        if (currentLoginInfo.getLoginCacheInfo().getSessionTokens().size() > 0) {
            cache.put((Object)(LOGIN_USER_PREFIX + currentLoginInfo.getLoginCacheInfo().getUsername()), (Object)currentLoginInfo.getLoginCacheInfo());
        } else {
            cache.evict((Object)(LOGIN_USER_PREFIX + currentLoginInfo.getLoginCacheInfo().getUsername()));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Map<Long, TokenInfo> getSessionTokens() {
        return this.sessionTokens;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setSessionTokens(Map<Long, TokenInfo> sessionTokens) {
        this.sessionTokens = sessionTokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginCacheInfo)) {
            return false;
        }
        LoginCacheInfo other = (LoginCacheInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        Map<Long, TokenInfo> this$sessionTokens = this.getSessionTokens();
        Map<Long, TokenInfo> other$sessionTokens = other.getSessionTokens();
        return !(this$sessionTokens == null ? other$sessionTokens != null : !((Object)this$sessionTokens).equals(other$sessionTokens));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginCacheInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        Map<Long, TokenInfo> $sessionTokens = this.getSessionTokens();
        result = result * 59 + ($sessionTokens == null ? 43 : ((Object)$sessionTokens).hashCode());
        return result;
    }

    public String toString() {
        return "LoginCacheInfo(username=" + this.getUsername() + ", authentication=" + this.getAuthentication() + ", sessionTokens=" + this.getSessionTokens() + ")";
    }
}

