/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.properties;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.security.properties.LockType;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="agile.security.error-sign")
public class ErrorSignProperties
implements Serializable {
    private boolean enable = true;
    private int maxErrorCount = 5;
    private Duration lockTime = Duration.ofMinutes(2L);
    private Duration countTimeout = Duration.ofMinutes(2L);
    private boolean lockForExpiration = true;
    private LockType[] lockType = new LockType[]{LockType.SESSION_ID};

    public AgileCache getCache() {
        return CacheUtil.getCache((String)"ErrorSign");
    }

    public boolean isEnable() {
        return this.enable;
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public Duration getLockTime() {
        return this.lockTime;
    }

    public Duration getCountTimeout() {
        return this.countTimeout;
    }

    public boolean isLockForExpiration() {
        return this.lockForExpiration;
    }

    public LockType[] getLockType() {
        return this.lockType;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount;
    }

    public void setLockTime(Duration lockTime) {
        this.lockTime = lockTime;
    }

    public void setCountTimeout(Duration countTimeout) {
        this.countTimeout = countTimeout;
    }

    public void setLockForExpiration(boolean lockForExpiration) {
        this.lockForExpiration = lockForExpiration;
    }

    public void setLockType(LockType[] lockType) {
        this.lockType = lockType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorSignProperties)) {
            return false;
        }
        ErrorSignProperties other = (ErrorSignProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getMaxErrorCount() != other.getMaxErrorCount()) {
            return false;
        }
        if (this.isLockForExpiration() != other.isLockForExpiration()) {
            return false;
        }
        Duration this$lockTime = this.getLockTime();
        Duration other$lockTime = other.getLockTime();
        if (this$lockTime == null ? other$lockTime != null : !((Object)this$lockTime).equals(other$lockTime)) {
            return false;
        }
        Duration this$countTimeout = this.getCountTimeout();
        Duration other$countTimeout = other.getCountTimeout();
        if (this$countTimeout == null ? other$countTimeout != null : !((Object)this$countTimeout).equals(other$countTimeout)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getLockType(), (Object[])other.getLockType());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorSignProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + this.getMaxErrorCount();
        result = result * 59 + (this.isLockForExpiration() ? 79 : 97);
        Duration $lockTime = this.getLockTime();
        result = result * 59 + ($lockTime == null ? 43 : ((Object)$lockTime).hashCode());
        Duration $countTimeout = this.getCountTimeout();
        result = result * 59 + ($countTimeout == null ? 43 : ((Object)$countTimeout).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getLockType());
        return result;
    }

    public String toString() {
        return "ErrorSignProperties(enable=" + this.isEnable() + ", maxErrorCount=" + this.getMaxErrorCount() + ", lockTime=" + this.getLockTime() + ", countTimeout=" + this.getCountTimeout() + ", lockForExpiration=" + this.isLockForExpiration() + ", lockType=" + Arrays.deepToString((Object[])this.getLockType()) + ")";
    }
}

