/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.properties;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.security.properties.ErrorSignProperties;
import cloud.agileframework.security.properties.PasswordProperties;
import cloud.agileframework.security.properties.TokenType;
import cloud.agileframework.security.properties.TransmissionMode;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.Duration;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="agile.security")
public class SecurityProperties
implements Serializable,
InitializingBean {
    private boolean enable = true;
    private Set<String> excludeUrl;
    private String loginUrl = "/api/login";
    private String loginOutUrl = "/api/logout";
    private String verificationCode = "verification";
    private Duration tokenTimeout = Duration.ofMinutes(30L);
    private String tokenHeader = "AGILE_TOKEN";
    private TransmissionMode[] tokenTransmissionMode = new TransmissionMode[]{TransmissionMode.COOKIE};
    private String loginUsername = "username";
    private String loginPassword = "password";
    private TokenType tokenType = TokenType.EASY;
    private String realIpHeader = "X-Real-Ip";
    private PasswordProperties password = new PasswordProperties();
    private ErrorSignProperties errorSign = new ErrorSignProperties();
    private String failForwardUrl = "/fail";
    private String successForwardUrl = "/success";
    private String successLogoutForwardUrl = "/logout-success";

    public AgileCache getCache() {
        return CacheUtil.getCache((String)this.getTokenHeader());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.excludeUrl == null) {
            this.excludeUrl = Sets.newHashSet();
        }
        this.excludeUrl.add(this.loginUrl);
        this.excludeUrl.add("/static/**");
        this.excludeUrl.add("/favicon.ico");
        this.excludeUrl.add("/actuator/**");
        this.excludeUrl.add("/actuator/*");
        this.excludeUrl.add("actuator");
        this.excludeUrl.add("/jolokia");
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setExcludeUrl(Set<String> excludeUrl) {
        this.excludeUrl = excludeUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setLoginOutUrl(String loginOutUrl) {
        this.loginOutUrl = loginOutUrl;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setTokenTimeout(Duration tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public void setTokenTransmissionMode(TransmissionMode[] tokenTransmissionMode) {
        this.tokenTransmissionMode = tokenTransmissionMode;
    }

    public void setLoginUsername(String loginUsername) {
        this.loginUsername = loginUsername;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public void setRealIpHeader(String realIpHeader) {
        this.realIpHeader = realIpHeader;
    }

    public void setPassword(PasswordProperties password) {
        this.password = password;
    }

    public void setErrorSign(ErrorSignProperties errorSign) {
        this.errorSign = errorSign;
    }

    public void setFailForwardUrl(String failForwardUrl) {
        this.failForwardUrl = failForwardUrl;
    }

    public void setSuccessForwardUrl(String successForwardUrl) {
        this.successForwardUrl = successForwardUrl;
    }

    public void setSuccessLogoutForwardUrl(String successLogoutForwardUrl) {
        this.successLogoutForwardUrl = successLogoutForwardUrl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Set<String> getExcludeUrl() {
        return this.excludeUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLoginOutUrl() {
        return this.loginOutUrl;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public Duration getTokenTimeout() {
        return this.tokenTimeout;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public TransmissionMode[] getTokenTransmissionMode() {
        return this.tokenTransmissionMode;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public PasswordProperties getPassword() {
        return this.password;
    }

    public ErrorSignProperties getErrorSign() {
        return this.errorSign;
    }

    public String getFailForwardUrl() {
        return this.failForwardUrl;
    }

    public String getSuccessForwardUrl() {
        return this.successForwardUrl;
    }

    public String getSuccessLogoutForwardUrl() {
        return this.successLogoutForwardUrl;
    }
}

