/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.provider;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.security.exception.LoginErrorLockException;
import cloud.agileframework.security.filter.login.ErrorSignInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.LoginErrorProvider;
import cloud.agileframework.security.provider.LoginValidateProvider;
import java.time.Duration;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;

public class ErrorSignLockLoginValidateProvider
implements LoginValidateProvider {
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private ObjectProvider<LoginErrorProvider> providers;

    @Override
    public void validate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws AuthenticationException {
        ErrorSignInfo errorSignInfo = ErrorSignInfo.of(request, username, this.securityProperties.getErrorSign().getLockType());
        request.setAttribute("AGILE_LOGIN_USERNAME", (Object)errorSignInfo);
        this.judgeLoginErrorLock(errorSignInfo);
    }

    private void judgeLoginErrorLock(ErrorSignInfo errorSignInfo) throws LoginErrorLockException {
        if (!this.securityProperties.getErrorSign().isEnable()) {
            return;
        }
        AgileCache cache = this.securityProperties.getErrorSign().getCache();
        Integer errorCount = (Integer)cache.get((Object)errorSignInfo.getLockObject(), Integer.class);
        if (errorCount != null && errorCount >= this.securityProperties.getErrorSign().getMaxErrorCount()) {
            boolean alwaysLock;
            errorSignInfo.setLockTime(new Date());
            Duration timeout = this.securityProperties.getErrorSign().getLockTime();
            boolean bl = alwaysLock = timeout.toMillis() <= 0L;
            if (alwaysLock) {
                cache.put((Object)errorSignInfo.getLockObject(), (Object)errorCount);
            } else {
                cache.put((Object)errorSignInfo.getLockObject(), (Object)errorCount, timeout);
                errorSignInfo.setTimeOut(new Date(errorSignInfo.getLockTime().getTime() + timeout.toMillis()));
            }
            this.providers.orderedStream().forEach(provider -> provider.lock(errorSignInfo));
            throw new LoginErrorLockException(alwaysLock ? "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u9501" : this.securityProperties.getErrorSign().getLockTime().toMinutes() + "\u5206\u949f");
        }
    }
}

