/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.provider;

import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.kaptcha.properties.KaptchaConfigProperties;
import cloud.agileframework.security.exception.VerificationCodeException;
import cloud.agileframework.security.exception.VerificationCodeExpire;
import cloud.agileframework.security.exception.VerificationCodeNon;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.LoginValidateProvider;
import cloud.agileframework.spring.util.ParamUtil;
import cloud.agileframework.spring.util.RequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;

public class KaptchaLoginValidateProvider
implements LoginValidateProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private KaptchaConfigProperties kaptchaConfigProperties;

    @Override
    public void validate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws AuthenticationException {
        String codeToken;
        String validateCode = (String)((RequestWrapper)(request = RequestWrapper.extract((HttpServletRequest)request))).getInParam(this.securityProperties.getVerificationCode(), String.class);
        if (validateCode == null) {
            throw new VerificationCodeNon();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("\u6b63\u5728\u767b\u9646...[\u9a8c\u8bc1\u7801\uff1a%s]", validateCode));
        }
        if ((codeToken = ParamUtil.getInfo((HttpServletRequest)request, (String)this.kaptchaConfigProperties.getTokenHeader())) == null) {
            throw new VerificationCodeException();
        }
        Object cacheCodeToken = CacheUtil.get((Object)codeToken);
        if (cacheCodeToken == null) {
            throw new VerificationCodeExpire();
        }
        if (!cacheCodeToken.toString().equalsIgnoreCase(validateCode)) {
            throw new VerificationCodeException(String.format("\u6b63\u786e\u503c:%s;\u8f93\u5165\u503c:%s", cacheCodeToken, validateCode));
        }
        CacheUtil.evict((Object)codeToken);
        Cookie cookie = new Cookie(this.kaptchaConfigProperties.getTokenHeader(), null);
        String cookiePath = request.getContextPath() + "/";
        cookie.setPath(cookiePath);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

