/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.util;

import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.properties.StrengthProperties;
import cloud.agileframework.security.properties.WeightMap;
import cloud.agileframework.spring.util.BeanUtil;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class PasswordUtil {
    public static final double NUM_TYPE_WEIGHT = 3.90625;
    public static final double LETTER_TYPE_WEIGHT = 10.15625;
    public static final double OTHER_TYPE_WEIGHT = 25.78125;
    private static final BCryptPasswordEncoder B_CRYPT_PASSWORD_ENCODER = new BCryptPasswordEncoder(4);
    private static final StrengthProperties STRENGTH_CONF = ((SecurityProperties)BeanUtil.getBean(SecurityProperties.class)).getPassword().getStrengthConf();
    private static final int MIN_NUM = 48;
    private static final int MAN_NUM = 57;
    private static final int MIN_CAPITAL_LETTER = 65;
    private static final int MAN_CAPITAL_LETTER = 90;
    private static final int MIN_SMALL_LETTER = 97;
    private static final int MAN_SMALL_LETTER = 122;
    private static final int NUM = 1;
    private static final int SMALL_LETTER = 2;
    private static final int CAPITAL_LETTER = 3;
    private static final int OTHER_CHAR = 4;
    private static double charLevel;

    private static int checkCharacterType(char c) {
        if (c >= '0' && c <= '9') {
            return 1;
        }
        if (c >= 'A' && c <= 'Z') {
            return 3;
        }
        if (c >= 'a' && c <= 'z') {
            return 2;
        }
        return 4;
    }

    private static int countLetter(String password, int type) {
        int count = 0;
        if (null != password && password.length() > 0) {
            for (char c : password.toCharArray()) {
                if (PasswordUtil.checkCharacterType(c) != type) continue;
                ++count;
            }
        }
        return count;
    }

    public static double checkPasswordStrength(String password) {
        if (StringUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("password is empty");
        }
        double level = PasswordUtil.init(password);
        level = PasswordUtil.parsingRegex(password, level);
        level = PasswordUtil.parsingKeyWord(password, level);
        return level;
    }

    private static double init(String password) {
        int lengthLevel = 50;
        assert (STRENGTH_CONF != null);
        int maxLength = STRENGTH_CONF.getMaxLength();
        charLevel = new BigDecimal(50).divide(new BigDecimal(maxLength), 10, 5).doubleValue();
        double level = (double)password.length() * charLevel;
        if (PasswordUtil.countLetter(password, 1) > 0) {
            level += 3.90625;
        }
        if (PasswordUtil.countLetter(password, 2) > 0) {
            level += 10.15625;
        }
        if (PasswordUtil.countLetter(password, 3) > 0) {
            level += 10.15625;
        }
        if (PasswordUtil.countLetter(password, 4) > 0) {
            level += 25.78125;
        }
        return level;
    }

    private static double parsingKeyWord(String password, double level) {
        assert (STRENGTH_CONF != null);
        double weightOfKeyWord = STRENGTH_CONF.getWeightOfKeyWord();
        List<String> keyWords = STRENGTH_CONF.getWeightOfKeyWords();
        BigDecimal countKewWords = new BigDecimal(keyWords.size());
        for (String keyWord : keyWords) {
            if (!password.contains(keyWord)) continue;
            double percentage = new BigDecimal(1).divide(countKewWords, 10, 5).doubleValue() * (charLevel * weightOfKeyWord);
            level -= (double)keyWord.length() * percentage;
        }
        return level;
    }

    private static double parsingRegex(String password, double level) {
        assert (STRENGTH_CONF != null);
        double weightOfRegex = STRENGTH_CONF.getWeightOfRegex();
        List<WeightMap> weightMaps = STRENGTH_CONF.getWeightOfRegexMap();
        double sum = weightMaps.stream().map(WeightMap::getWeight).mapToDouble(a -> a).sum();
        for (WeightMap weightMap : weightMaps) {
            double weight = weightMap.getWeight();
            double percentage = new BigDecimal(weight).divide(new BigDecimal(sum), 10, 5).doubleValue() * (charLevel * weightOfRegex);
            level = PasswordUtil.regexScoring(weightMap.getRegex(), password, level, percentage);
        }
        return level;
    }

    public static LEVEL getPasswordLevel(String password) {
        double weight = 3.6;
        double level = PasswordUtil.checkPasswordStrength(password);
        if (level <= 3.6) {
            return LEVEL.SO_EASY;
        }
        if (level <= 27.0) {
            return LEVEL.EASY;
        }
        if (level <= 36.0) {
            return LEVEL.ORDINARY;
        }
        if (level <= 45.0) {
            return LEVEL.STRONG;
        }
        return LEVEL.SO_STRONG;
    }

    public static String encryption(String clear) {
        return B_CRYPT_PASSWORD_ENCODER.encode((CharSequence)clear);
    }

    public static boolean decryption(String clear, String cipher) {
        return B_CRYPT_PASSWORD_ENCODER.matches((CharSequence)clear, cipher);
    }

    private static double regexScoring(String regex, String text, double level, double weight) {
        List matches = PatternUtil.getMatched((String)regex, (String)text);
        int sum = matches.stream().map(String::length).mapToInt(s -> s).sum();
        return level -= (double)sum * (1.0 - weight);
    }

    public static enum LEVEL {
        SO_EASY,
        EASY,
        ORDINARY,
        STRONG,
        SO_STRONG;

    }
}

