/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.util;

import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.common.util.rsa.RSAUtil;
import cloud.agileframework.security.filter.token.LoginCacheInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.properties.TransmissionMode;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.IdUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.ObjectUtils;

public class TokenUtil {
    public static final String AUTHENTICATION_USER_NAME = "AUTHENTICATION_USER_NAME";
    public static final String AUTHENTICATION_SESSION_TOKEN = "AUTHENTICATION_SESSION_TOKEN";
    private static final String AUTHENTICATION_CREATE_TIME = "created";
    private static final SecurityProperties SECURITY_PROPERTIES = (SecurityProperties)BeanUtil.getBean(SecurityProperties.class);
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static final String KEY_PAIR_CACHE_KEY = "$AGILE_SECURITY_RSA_KEY_PAIR$";
    private static final String RSA = "RSA";
    private static final int KEY_SIZE = 2048;

    private static void init() {
        String text = (String)LoginCacheInfo.getCache().get((Object)KEY_PAIR_CACHE_KEY, String.class);
        KeyPair keyPair = RSAUtil.toKeyPair((String)text);
        if (keyPair == null) {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA);
            keyPairGen.initialize(2048);
            keyPair = keyPairGen.generateKeyPair();
            LoginCacheInfo.getCache().put((Object)KEY_PAIR_CACHE_KEY, (Object)RSAUtil.toString((KeyPair)keyPair));
        }
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
    }

    public static PrivateKey getPrivateKey() {
        if (privateKey == null) {
            TokenUtil.init();
        }
        return privateKey;
    }

    public static PublicKey getPublicKey() {
        if (publicKey == null) {
            TokenUtil.init();
        }
        return publicKey;
    }

    public static String generateToken(String username, Long sessionToken, Date timeout) {
        int length = 4;
        HashMap<String, Object> claims = new HashMap<String, Object>(4);
        claims.put(AUTHENTICATION_USER_NAME, username);
        claims.put(AUTHENTICATION_SESSION_TOKEN, sessionToken);
        claims.put(AUTHENTICATION_CREATE_TIME, DateUtil.getCurrentDate());
        return TokenUtil.generateToken(claims, timeout);
    }

    public static String generateToken(Map<String, Object> claims, Date timeout) {
        return Jwts.builder().setIssuer("agile").setIssuedAt(DateUtil.getCurrentDate()).setSubject("Login").setAudience("System Users").setNotBefore(DateUtil.getCurrentDate()).setId(Long.toString(IdUtil.generatorId())).setClaims(claims).setExpiration(timeout).signWith(SignatureAlgorithm.RS512, (Key)TokenUtil.getPrivateKey()).compact();
    }

    public static void notice(HttpServletRequest request, HttpServletResponse response, String token) {
        TransmissionMode[] modes;
        block6: for (TransmissionMode mode : modes = SECURITY_PROPERTIES.getTokenTransmissionMode()) {
            switch (mode) {
                case COOKIE: {
                    response.addCookie(new Cookie(SECURITY_PROPERTIES.getTokenHeader(), token));
                    continue block6;
                }
                case HEADER: {
                    response.setHeader(SECURITY_PROPERTIES.getTokenHeader(), token);
                    continue block6;
                }
            }
        }
        request.setAttribute(SECURITY_PROPERTIES.getTokenHeader(), (Object)token);
    }

    public static Claims getClaimsFromToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey((Key)TokenUtil.getPublicKey()).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validateToken(String token) {
        Claims claims = TokenUtil.getClaimsFromToken(token);
        if (ObjectUtils.isEmpty((Object)claims)) {
            return false;
        }
        return claims.getExpiration().after(DateUtil.getCurrentDate());
    }
}

