/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.config;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.security.filter.login.JwtAuthenticationProvider;
import cloud.agileframework.security.filter.simulation.SimulationFilter;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.properties.SimulationProperties;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.core.userdetails.UserDetails;

@Configuration
@EnableConfigurationProperties(value={SimulationProperties.class, SecurityProperties.class})
@ConditionalOnProperty(name={"enable"}, prefix="agile.simulation")
public class SimulationAutoConfiguration
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private SimulationProperties simulationProperties;

    @Bean
    @Conditional(value={Is.class})
    public FilterRegistrationBean<SimulationFilter> simulationFilter() {
        this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316\u6a21\u62df\u8d26\u6237\u8fc7\u6ee4\u5668");
        FilterRegistrationBean simulationFilter = new FilterRegistrationBean();
        simulationFilter.setFilter((Filter)new SimulationFilter(this.simulationProperties));
        simulationFilter.addUrlPatterns(new String[]{"/*"});
        simulationFilter.setOrder(Integer.MIN_VALUE);
        return simulationFilter;
    }

    public void afterPropertiesSet() {
        if (this.securityProperties.isEnable()) {
            UserDetails user = (UserDetails)ObjectUtil.to((Object)this.simulationProperties.getUser(), (TypeReference)new TypeReference(this.simulationProperties.getUserClass()));
            if (user == null) {
                throw new RuntimeException("\u6a21\u62df\u8d26\u6237\u6570\u636euser\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807userClass\u7c7b\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9");
            }
            JwtAuthenticationProvider.setSimulation(user);
        }
    }

    public static class Is
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            if (beanFactory == null) {
                return true;
            }
            Boolean need = (Boolean)context.getEnvironment().getProperty("agile.security.enable", Boolean.class, (Object)false);
            return need == false;
        }
    }
}

