/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.login.ErrorSignInfo;
import cloud.agileframework.security.filter.token.LoginCacheInfo;
import cloud.agileframework.security.filter.token.TokenInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.util.TokenUtil;
import cloud.agileframework.spring.util.IdUtil;
import cloud.agileframework.spring.util.ServletUtil;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.RememberMeServices;

public class CustomRememberMeServices
implements RememberMeServices,
InitializingBean {
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private CustomerUserDetailsService securityUserDetailsService;
    private AgileCache cache;

    public void afterPropertiesSet() throws Exception {
        this.cache = CacheUtil.getCache((String)this.securityProperties.getTokenHeader());
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.failureCount(request);
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        UserDetails userDetails = (UserDetails)successfulAuthentication.getPrincipal();
        String username = userDetails.getUsername();
        long sessionToken = IdUtil.generatorId();
        String token = TokenUtil.generateToken(username, sessionToken, DateUtil.add((Date)new Date(), (Duration)Duration.of(365L, ChronoUnit.DAYS)));
        TokenInfo tokenInfo = LoginCacheInfo.createTokenInfo(token, new Date(), DateUtil.add((Date)new Date(), (Duration)this.securityProperties.getTokenTimeout()));
        LoginCacheInfo loginCacheInfo = LoginCacheInfo.createLoginCacheInfo(username, successfulAuthentication, sessionToken, tokenInfo);
        this.cache.put((Object)("LOGIN_USER_" + username), (Object)loginCacheInfo);
        this.securityUserDetailsService.loadLoginInfo(userDetails, ServletUtil.getRequestIP((HttpServletRequest)request), Long.toString(sessionToken));
        TokenUtil.notice(request, response, token);
        ((UsernamePasswordAuthenticationToken)successfulAuthentication).setDetails((Object)tokenInfo);
    }

    private void failureCount(HttpServletRequest request) {
        if (!this.securityProperties.getErrorSign().isEnable()) {
            return;
        }
        AgileCache errorSignCache = this.securityProperties.getErrorSign().getCache();
        ErrorSignInfo errorSignInfo = (ErrorSignInfo)request.getAttribute("AGILE_LOGIN_USERNAME");
        Duration countTimeout = this.securityProperties.getErrorSign().getCountTimeout();
        Integer errorCount = (Integer)errorSignCache.get((Object)errorSignInfo.getLockObject(), Integer.class);
        if (errorCount == null) {
            errorSignCache.put((Object)errorSignInfo.getLockObject(), (Object)1, countTimeout);
        } else {
            errorCount = errorCount + 1;
            errorSignCache.put((Object)errorSignInfo.getLockObject(), (Object)errorCount, countTimeout);
        }
        request.removeAttribute("AGILE_LOGIN_USERNAME");
    }
}

