/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.provider.LoginValidateProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private CustomerUserDetailsService userDetailsService;
    private ObjectProvider<LoginValidateProvider> loginValidateProviders;
    private static UserDetails simulation;

    public void setUserDetailsService(CustomerUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setLoginValidateProviders(ObjectProvider<LoginValidateProvider> loginValidateProviders) {
        this.loginValidateProviders = loginValidateProviders;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        this.userDetailsService.validate(userDetails);
        List providers = this.loginValidateProviders.orderedStream().collect(Collectors.toList());
        for (LoginValidateProvider provider : providers) {
            provider.validate((Authentication)authentication, userDetails);
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (username != null && simulation != null && username.equals(simulation.getUsername())) {
            return simulation;
        }
        return this.userDetailsService.loadUserByUsername(username);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.equals(authentication);
    }

    public static void setSimulation(UserDetails simulation) {
        JwtAuthenticationProvider.simulation = simulation;
    }
}

