/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.login.JwtAuthenticationProvider;
import cloud.agileframework.security.filter.login.SingleSignOnProvider;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.LoginValidateProvider;
import cloud.agileframework.security.provider.PasswordProvider;
import cloud.agileframework.spring.util.RequestWrapper;
import cloud.agileframework.spring.util.ServletUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationFailureHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class LoginFilter
extends AbstractAuthenticationProcessingFilter
implements InitializingBean,
SingleSignOnProvider,
ApplicationContextAware {
    @Autowired
    private JwtAuthenticationProvider loginStrategyProvider;
    @Autowired
    private CustomerUserDetailsService userDetailsService;
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired
    private PasswordProvider passwordProvider;
    @Autowired
    private ObjectProvider<LoginValidateProvider> loginValidateProviders;
    @Autowired
    private RememberMeServices rememberMeServices;
    private ApplicationContext applicationContext;

    public LoginFilter(String loginUrl) {
        super((RequestMatcher)new AntPathRequestMatcher(loginUrl));
    }

    public void afterPropertiesSet() {
        this.setAllowSessionCreation(false);
        this.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new ForwardAuthenticationSuccessHandler(this.securityProperties.getSuccessForwardUrl()));
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new ForwardAuthenticationFailureHandler(this.securityProperties.getFailForwardUrl()));
        ProviderManager providerManager = new ProviderManager(Collections.singletonList(this.loginStrategyProvider));
        providerManager.setEraseCredentialsAfterAuthentication(false);
        this.setAuthenticationManager((AuthenticationManager)providerManager);
        this.loginStrategyProvider.setUserDetailsService(this.userDetailsService);
        this.loginStrategyProvider.setLoginValidateProviders(this.loginValidateProviders);
        this.setRememberMeServices(this.rememberMeServices);
        this.setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            return authentication;
        }
        request = RequestWrapper.extract((HttpServletRequest)request);
        String sourceUsername = (String)((RequestWrapper)request).getInParam(this.securityProperties.getLoginUsername(), String.class);
        String sourcePassword = (String)((RequestWrapper)request).getInParam(this.securityProperties.getLoginPassword(), String.class);
        sourcePassword = this.passwordProvider.decrypt(sourcePassword);
        List providers = this.loginValidateProviders.orderedStream().collect(Collectors.toList());
        for (LoginValidateProvider provider : providers) {
            provider.validate(request, response, sourceUsername, sourcePassword);
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)sourceUsername, (Object)sourcePassword);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    private void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    @Override
    public Authentication sign(String username) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, null);
        Authentication auth = this.getAuthenticationManager().authenticate((Authentication)authRequest);
        this.getRememberMeServices().loginSuccess(ServletUtil.getCurrentRequest(), ServletUtil.getCurrentResponse(), auth);
        return auth;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

