/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.token;

import cloud.agileframework.security.filter.token.CurrentLoginInfo;
import cloud.agileframework.security.filter.token.LoginCacheInfo;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.properties.TokenType;
import cloud.agileframework.security.util.TokenUtil;
import cloud.agileframework.spring.util.ParamUtil;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.spring.util.ServletUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class TokenFilter
extends OncePerRequestFilter {
    private final AccessDeniedHandlerImpl failureHandler = new AccessDeniedHandlerImpl();
    private List<RequestMatcher> matches;
    @Autowired
    private SecurityProperties securityProperties;

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        this.matches = ServletUtil.coverRequestMatcher((String[])this.securityProperties.getExcludeUrl().toArray(new String[0]));
        this.failureHandler.setErrorPage(this.securityProperties.getFailForwardUrl());
    }

    protected void doFilterNestedErrorDispatch(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        super.doFilterNestedErrorDispatch(request, response, filterChain);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication instanceof UsernamePasswordAuthenticationToken || ServletUtil.matcherRequest((HttpServletRequest)request, this.matches)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String token = ParamUtil.getInfo((HttpServletRequest)request, (String)this.securityProperties.getTokenHeader());
            CurrentLoginInfo currentLoginInfo = LoginCacheInfo.getCurrentLoginInfo(token);
            LoginCacheInfo.validateCacheDate(currentLoginInfo.getLoginCacheInfo());
            Authentication currentAuthentication = currentLoginInfo.getLoginCacheInfo().getAuthentication();
            SecurityUtil.setCurrentUser((HttpServletRequest)request, (Authentication)currentAuthentication);
            SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (this.securityProperties.getTokenType() == TokenType.DIFFICULT) {
                String newToken = LoginCacheInfo.refreshToken(currentLoginInfo);
                TokenUtil.notice(request, response, newToken);
            }
        }
        catch (Exception e) {
            this.failureHandler.handle(request, response, new AccessDeniedException("\u4ee4\u724c\u9a8c\u8bc1\u5931\u8d25", (Throwable)e));
        }
    }
}

