/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.properties;

import cloud.agileframework.security.properties.WeightMap;
import java.io.Serializable;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="agile.security.password.strength-conf")
public class StrengthProperties
implements Serializable {
    private int maxLength = 32;
    private double weightOfRegex = 0.65;
    private double weightOfKeyWord;
    private List<WeightMap> weightOfRegexMap;
    private List<String> weightOfKeyWords;

    public int getMaxLength() {
        return this.maxLength;
    }

    public double getWeightOfRegex() {
        return this.weightOfRegex;
    }

    public double getWeightOfKeyWord() {
        return this.weightOfKeyWord;
    }

    public List<WeightMap> getWeightOfRegexMap() {
        return this.weightOfRegexMap;
    }

    public List<String> getWeightOfKeyWords() {
        return this.weightOfKeyWords;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setWeightOfRegex(double weightOfRegex) {
        this.weightOfRegex = weightOfRegex;
    }

    public void setWeightOfKeyWord(double weightOfKeyWord) {
        this.weightOfKeyWord = weightOfKeyWord;
    }

    public void setWeightOfRegexMap(List<WeightMap> weightOfRegexMap) {
        this.weightOfRegexMap = weightOfRegexMap;
    }

    public void setWeightOfKeyWords(List<String> weightOfKeyWords) {
        this.weightOfKeyWords = weightOfKeyWords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrengthProperties)) {
            return false;
        }
        StrengthProperties other = (StrengthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (Double.compare(this.getWeightOfRegex(), other.getWeightOfRegex()) != 0) {
            return false;
        }
        if (Double.compare(this.getWeightOfKeyWord(), other.getWeightOfKeyWord()) != 0) {
            return false;
        }
        List<WeightMap> this$weightOfRegexMap = this.getWeightOfRegexMap();
        List<WeightMap> other$weightOfRegexMap = other.getWeightOfRegexMap();
        if (this$weightOfRegexMap == null ? other$weightOfRegexMap != null : !((Object)this$weightOfRegexMap).equals(other$weightOfRegexMap)) {
            return false;
        }
        List<String> this$weightOfKeyWords = this.getWeightOfKeyWords();
        List<String> other$weightOfKeyWords = other.getWeightOfKeyWords();
        return !(this$weightOfKeyWords == null ? other$weightOfKeyWords != null : !((Object)this$weightOfKeyWords).equals(other$weightOfKeyWords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StrengthProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLength();
        long $weightOfRegex = Double.doubleToLongBits(this.getWeightOfRegex());
        result = result * 59 + (int)($weightOfRegex >>> 32 ^ $weightOfRegex);
        long $weightOfKeyWord = Double.doubleToLongBits(this.getWeightOfKeyWord());
        result = result * 59 + (int)($weightOfKeyWord >>> 32 ^ $weightOfKeyWord);
        List<WeightMap> $weightOfRegexMap = this.getWeightOfRegexMap();
        result = result * 59 + ($weightOfRegexMap == null ? 43 : ((Object)$weightOfRegexMap).hashCode());
        List<String> $weightOfKeyWords = this.getWeightOfKeyWords();
        result = result * 59 + ($weightOfKeyWords == null ? 43 : ((Object)$weightOfKeyWords).hashCode());
        return result;
    }

    public String toString() {
        return "StrengthProperties(maxLength=" + this.getMaxLength() + ", weightOfRegex=" + this.getWeightOfRegex() + ", weightOfKeyWord=" + this.getWeightOfKeyWord() + ", weightOfRegexMap=" + this.getWeightOfRegexMap() + ", weightOfKeyWords=" + this.getWeightOfKeyWords() + ")";
    }
}

