/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.provider;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.security.exception.RepeatAccount;
import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.security.properties.LoginStrategy;
import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.LoginValidateProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class LoginStrategyLoginValidateProvider
implements LoginValidateProvider {
    @Autowired
    private SecurityProperties securityProperties;

    @Override
    public void validate(Authentication authentication, UserDetails user) throws AuthenticationException {
        if (!(user instanceof CustomerUserDetails)) {
            return;
        }
        LoginStrategy loginStrategy = ((CustomerUserDetails)user).getLoginStrategy();
        if (loginStrategy != null) {
            switch (loginStrategy) {
                case SINGLETON_REPLACE: {
                    AgileCache cache = CacheUtil.getCache((String)this.securityProperties.getTokenHeader());
                    cache.evict((Object)user.getUsername());
                    break;
                }
                case MORE: {
                    break;
                }
                default: {
                    throw new RepeatAccount("\u91cd\u590d\u8d26\u6237\u767b\u5f55");
                }
            }
        }
    }
}

