/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.task;

import cloud.agileframework.task.RunDetail;
import cloud.agileframework.task.Target;
import cloud.agileframework.task.Task;
import cloud.agileframework.task.TaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServiceImpl
implements TaskService {
    private final Logger logger = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final List<Task> TASKS_CACHE = new ArrayList<Task>();

    @Override
    public List<Task> getTask() {
        return TASKS_CACHE;
    }

    @Override
    public List<Target> getApisByTaskCode(long code) {
        Optional<Task> task = TASKS_CACHE.stream().filter(node -> node.getCode().equals(code)).findFirst();
        if (task.isPresent()) {
            return task.get().targets();
        }
        return new ArrayList<Target>(0);
    }

    @Override
    public List<Task> getTasksByApiCode(String code) {
        return TASKS_CACHE.stream().filter(node -> node.targets().stream().anyMatch(n -> code.equals(node.getCode().toString()))).collect(Collectors.toList());
    }

    @Override
    public void save(Task task) {
        TASKS_CACHE.removeIf(node -> node.getCode().equals(task.getCode()));
        TASKS_CACHE.add(task);
    }

    @Override
    public void remove(long taskCode) {
        TASKS_CACHE.removeIf(node -> node.getCode().equals(taskCode));
    }

    @Override
    public void run(long taskCode) {
    }

    @Override
    public void finish(long taskCode) {
    }

    @Override
    public void logging(RunDetail runDetail) {
        this.logger.debug(runDetail.getLog().toString());
    }

    @Override
    public boolean setNxLock(long taskCode, Date unlockTime) {
        return true;
    }

    @Override
    public void unLock(long taskCode) {
    }

    @Override
    public void enable(long taskCode, boolean enable) {
        Optional<Task> optional = TASKS_CACHE.stream().filter(task -> task.getCode().equals(taskCode)).findFirst();
        if (optional.isPresent()) {
            final Task task2 = optional.get();
            TASKS_CACHE.remove(task2);
            TASKS_CACHE.add(new Task(){

                @Override
                public Long getCode() {
                    return task2.getCode();
                }

                @Override
                public String getName() {
                    return task2.getName();
                }

                @Override
                public String getCron() {
                    return task2.getCron();
                }

                @Override
                public Boolean getSync() {
                    return task2.getSync();
                }

                @Override
                public Boolean getEnable() {
                    return task2.getEnable() == false;
                }

                @Override
                public List<Target> targets() {
                    return task2.targets();
                }
            });
        }
    }
}

