/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.validate;

import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateType;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.annotation.Validates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    private ValidateUtil() {
    }

    public static List<ValidateMsg> handleInParamValidate(Method method, Object params) {
        Optional<Validates> validatesOptional = Optional.ofNullable(method.getAnnotation(Validates.class));
        Optional<Validate> validateOptional = Optional.ofNullable(method.getAnnotation(Validate.class));
        ArrayList validateList = Lists.newArrayList();
        validatesOptional.ifPresent(validates -> validateList.addAll(Stream.of(validates.value()).collect(Collectors.toList())));
        validateOptional.ifPresent(validateList::add);
        return validateList.stream().map(validate -> ValidateUtil.handleValidateAnnotation(validate, params)).reduce((all, validateMsgList) -> {
            all.addAll(validateMsgList);
            return all;
        }).orElse(Lists.newArrayList());
    }

    private static List<ValidateMsg> handleValidateAnnotation(Validate v, Object params) {
        ArrayList<ValidateMsg> list = new ArrayList<ValidateMsg>();
        if (v == null) {
            return list;
        }
        String key = v.value().trim();
        Object value = StringUtils.isBlank((CharSequence)key) ? params : JSONUtil.pathGet((String)key, (Object)params);
        ValidateType validateType = v.validateType();
        if (value != null && List.class.isAssignableFrom(value.getClass())) {
            list.addAll(validateType.validateArray(key, (List)value, v));
        } else {
            list.addAll(validateType.validateParam(key, value, v));
        }
        return list;
    }

    public static List<ValidateMsg> aggregation(List<ValidateMsg> list) {
        List<ValidateMsg> errors = list.parallelStream().filter(validateMsg -> !validateMsg.isState()).collect(Collectors.toList());
        HashMap cache = Maps.newHashMapWithExpectedSize((int)errors.size());
        errors.forEach(validateMsg -> {
            String key = validateMsg.getItem();
            if (cache.containsKey(key)) {
                ((ValidateMsg)cache.get(key)).addMessage(validateMsg.getMessage());
            } else {
                cache.put(key, validateMsg);
            }
        });
        if (cache.size() > 0) {
            return new ArrayList<ValidateMsg>(cache.values());
        }
        return new ArrayList<ValidateMsg>(0);
    }

    public static List<ValidateMsg> validate(Object pojo, Class<?> ... groups) {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set set = validator.validate(pojo, (Class[])groups);
        ArrayList<ValidateMsg> list = new ArrayList<ValidateMsg>();
        if (set == null || set.isEmpty()) {
            return list;
        }
        for (ConstraintViolation m : set) {
            ValidateMsg r = new ValidateMsg(m.getMessage(), false, m.getPropertyPath().toString(), m.getInvalidValue());
            list.add(r);
        }
        return list;
    }
}

