/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.validate;

import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.validate.ValidateConfig;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.ValidateType;
import cloud.agileframework.validate.annotation.Validate;
import cloud.agileframework.validate.annotation.Validates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    public static final ValidatorFactory VALIDATOR_FACTORY = Validation.buildDefaultValidatorFactory();
    public static final Validator VALIDATOR = VALIDATOR_FACTORY.getValidator();

    private ValidateUtil() {
    }

    public static List<ValidateMsg> handleInParamValidate(Method method, Object params) {
        Optional<Validates> validatesOptional = Optional.ofNullable(method.getAnnotation(Validates.class));
        Optional<Validate> validateOptional = Optional.ofNullable(method.getAnnotation(Validate.class));
        ArrayList validateList = Lists.newArrayList();
        validatesOptional.ifPresent(validates -> validateList.addAll(Stream.of(validates.value()).map(ValidateConfig::new).collect(Collectors.toList())));
        validateOptional.ifPresent(validate -> validateList.add(new ValidateConfig((Validate)validate)));
        return ValidateUtil.handleValidateData(params, validateList);
    }

    public static List<ValidateMsg> handleValidateData(Object data, List<ValidateConfig> validateList) {
        return validateList.stream().map(validateConfig -> {
            String key = validateConfig.getValue().trim();
            Object value = StringUtils.isBlank((CharSequence)key) ? data : JSONUtil.pathGet((String)key, (Object)data);
            return ValidateUtil.handleValidate(value, validateConfig);
        }).reduce((all, validateMsgList) -> {
            all.addAll(validateMsgList);
            return all;
        }).orElse(Lists.newArrayList());
    }

    private static List<ValidateMsg> handleValidate(Object value, ValidateConfig v) {
        if (v == null) {
            return Lists.newArrayList();
        }
        String key = v.getValue().trim();
        if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
            return ValidateType.validateArray(key, (Collection)value, v);
        }
        return ValidateType.validateParam(key, value, v);
    }

    public static List<ValidateMsg> aggregation(List<ValidateMsg> list) {
        HashMap cache = Maps.newHashMapWithExpectedSize((int)list.size());
        list.forEach(validateMsg -> {
            String key = validateMsg.getItem();
            if (cache.containsKey(key)) {
                ((ValidateMsg)cache.get(key)).addMessage(validateMsg.getMessage());
            } else {
                cache.put(key, validateMsg);
            }
        });
        if (cache.size() > 0) {
            return new ArrayList<ValidateMsg>(cache.values());
        }
        return new ArrayList<ValidateMsg>(0);
    }

    public static List<ValidateMsg> validate(Object pojo, Class<?> ... groups) {
        if (pojo == null) {
            return Lists.newArrayList();
        }
        Set set = VALIDATOR.validate(pojo, (Class[])groups);
        if (set == null || set.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        for (ConstraintViolation m : set) {
            ValidateMsg r = new ValidateMsg(m.getMessage(), m.getPropertyPath().toString(), m.getInvalidValue());
            list.add(r);
        }
        return list;
    }
}

