/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.kaptcha.kaptcha;

import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.kaptcha.properties.KaptchaConfigProperties;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class KaptchaContextHolder {
    private static KaptchaConfigProperties kaptchaConfigProperties;

    private KaptchaContextHolder() {
    }

    public static void initConfig(KaptchaConfigProperties kaptchaConfigProperties) {
        KaptchaContextHolder.kaptchaConfigProperties = kaptchaConfigProperties;
    }

    public static String code(HttpServletRequest request) {
        String codeToken = KaptchaContextHolder.codeToken(request);
        return (String)CacheUtil.get((Object)codeToken, String.class);
    }

    public static String codeToken(HttpServletRequest req) {
        String codeToken = req.getHeader(kaptchaConfigProperties.getTokenHeader());
        if (codeToken == null && req.getCookies() != null) {
            codeToken = Arrays.stream(req.getCookies()).filter(cookie -> cookie.getName().equals(kaptchaConfigProperties.getTokenHeader())).map(Cookie::getValue).findFirst().orElse(null);
        }
        if (codeToken == null) {
            codeToken = (String)req.getAttribute(kaptchaConfigProperties.getTokenHeader());
        }
        return codeToken;
    }
}

