/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.kaptcha.properties;

import java.time.Duration;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="agile.kaptcha")
public class KaptchaConfigProperties
implements InitializingBean {
    private boolean enable = true;
    private String url = "/code";
    private String text;
    private String tokenHeader = "V-CODE";
    private Duration liveTime = Duration.ofMinutes(1L);
    private Properties properties;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public Duration getLiveTime() {
        return this.liveTime;
    }

    public void setLiveTime(Duration liveTime) {
        this.liveTime = liveTime;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.properties == null) {
            this.properties = new Properties();
            this.properties.put("kaptcha.background.clear.from", "45,45,45");
            this.properties.put("kaptcha.background.clear.to", "45,45,45");
            this.properties.put("kaptcha.noise.color", "white");
            this.properties.put("kaptcha.border", "yes");
            this.properties.put("kaptcha.border.color", "white");
            this.properties.put("kaptcha.textproducer.font.color", "white");
            this.properties.put("kaptcha.textproducer.font.size", "40");
            this.properties.put("kaptcha.image.width", "125");
            this.properties.put("kaptcha.image.height", "45");
            this.properties.put("kaptcha.textproducer.char.length", "4");
            this.properties.put("kaptcha.textproducer.font.names", "\u5fae\u8f6f\u96c5\u9ed1");
            this.properties.put("kaptcha.textproducer.impl", "cloud.agileframework.kaptcha.kaptcha.AgileTextProducer");
            this.properties.put("kaptcha.obscurificator.impl", "com.google.code.kaptcha.impl.ShadowGimpy");
        }
    }
}

