/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;

public class DynamicUtil {
    public static DynamicBean of(Class<?> superclass, Map<String, Class<?>> propertyMap) {
        return new DynamicBean(superclass, propertyMap);
    }

    public static DynamicBean withProperty(Class<?> superclass, String fieldName, Object fieldValue) {
        return new DynamicBean(superclass, fieldName, fieldValue);
    }

    public static DynamicBean withProperties(Class<?> superclass, Map<String, Object> valueMap, String ... excludeFields) {
        Map<String, Class<?>> classMap = valueMap.entrySet().stream().filter(property -> {
            Field field = ClassUtil.getField((Class)superclass, (String)((String)property.getKey()));
            return field == null;
        }).collect(Collectors.toMap(Map.Entry::getKey, b -> Object.class));
        DynamicBean dynamicBean = DynamicUtil.of(superclass, classMap);
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            if (entry.getValue() == null || ArrayUtils.contains((Object[])excludeFields, (Object)entry.getKey())) continue;
            try {
                dynamicBean.setValue(entry.getKey(), entry.getValue());
            }
            catch (Exception exception) {}
        }
        return dynamicBean;
    }

    public static DynamicBean withPropertyByObject(Object superObject, String fieldName, Object fieldValue, String ... excludeFields) {
        if (superObject == null) {
            return null;
        }
        HashMap valueMap = Maps.newHashMap();
        valueMap.put(fieldName, fieldValue);
        return DynamicUtil.withPropertyByObject(superObject, valueMap, excludeFields);
    }

    public static DynamicBean withPropertyByObject(Object superObject, Map<String, Object> valueMap, String ... excludeFields) {
        if (superObject == null) {
            return null;
        }
        Map oldValues = (Map)ObjectUtil.to((Object)superObject, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (oldValues != null) {
            valueMap.putAll(oldValues);
        }
        return DynamicUtil.withProperties(superObject.getClass(), valueMap, excludeFields);
    }

    public static class DynamicBean {
        private final Object target;
        private final BeanMap beanMap;

        public DynamicBean(Class<?> superclass, Map<String, Class<?>> propertyMap) {
            this.target = this.generateBean(superclass, propertyMap);
            this.beanMap = BeanMap.create((Object)this.target);
        }

        public DynamicBean(Class<?> superclass, String fieldName, Object fieldValue) {
            if (fieldValue == null) {
                throw new IllegalArgumentException();
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put(fieldName, fieldValue.getClass());
            this.target = this.generateBean(superclass, map);
            this.beanMap = BeanMap.create((Object)this.target);
            this.setValue(fieldName, fieldValue);
        }

        public void setValue(String property, Object value) {
            this.beanMap.put((Object)property, value);
        }

        public Object getValue(String property) {
            return this.beanMap.get((Object)property);
        }

        public Object getTarget() {
            return this.target;
        }

        public BeanMap getBeanMap() {
            return this.beanMap;
        }

        private Object generateBean(Class<?> superclass, Map<String, Class<?>> propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            if (null != superclass) {
                generator.setSuperclass(superclass);
                generator.setClassLoader(superclass.getClassLoader());
            }
            BeanGenerator.addProperties((BeanGenerator)generator, propertyMap);
            return generator.create();
        }
    }
}

