/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.BeanUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageUtil {
    private static MessageSource messageSource;

    private static void init() {
        messageSource = BeanUtil.getBean(MessageSource.class);
        if (messageSource == null) {
            throw new NoSuchBeanDefinitionException(MessageSource.class);
        }
    }

    public static String message(String key) {
        try {
            return MessageUtil.messageRequire(key, null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String message(String key, String defaultValue, Object ... params) {
        try {
            return MessageUtil.messageRequire(key, defaultValue, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String messageRequire(String key, String defaultValue, Object ... params) {
        if (messageSource == null) {
            MessageUtil.init();
        }
        return messageSource.getMessage(key, params, defaultValue, LocaleContextHolder.getLocale());
    }
}

