/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;

public class MappingUtil {
    private static final String HANDLE_METHOD = "$cloud.agileframework.handlerMethod";

    public static HandlerMethod matching(HttpServletRequest request) {
        HandlerMethod handlerMethod = (HandlerMethod)request.getAttribute(HANDLE_METHOD);
        if (handlerMethod != null) {
            return handlerMethod;
        }
        ObjectProvider handlerMappings = BeanUtil.getApplicationContext().getBeanProvider(MatchableHandlerMapping.class);
        handlerMethod = handlerMappings.orderedStream().map(handlerMapping -> {
            try {
                Object handler;
                HashMap map = Maps.newHashMap();
                Enumeration keys = request.getAttributeNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    map.put(key, request.getAttribute(key));
                }
                HandlerExecutionChain handlerExecutionChain = handlerMapping.getHandler(request);
                for (Map.Entry entry : map.entrySet()) {
                    request.setAttribute((String)entry.getKey(), entry.getValue());
                }
                if (handlerExecutionChain != null && (handler = handlerExecutionChain.getHandler()) instanceof HandlerMethod) {
                    return (HandlerMethod)handler;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
        request.setAttribute(HANDLE_METHOD, (Object)handlerMethod);
        return handlerMethod;
    }
}

