/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.collection.IterablesUtil;
import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.common.util.properties.PropertiesUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.spring.exception.CreateFileException;
import cloud.agileframework.spring.util.BeanUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.util.WebUtils;

public class MultipartFileUtil {
    private static String tempPath;

    public static Map<String, Object> getFileFormRequest(HttpServletRequest request) {
        MultipartHttpServletRequest childMultipartRequest;
        int length = 16;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (multipartRequest == null) {
            MultipartResolver multipartResolver = BeanUtil.getBean(MultipartResolver.class);
            if (multipartResolver instanceof CommonsMultipartResolver) {
                CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
                multipartRequest = resolver.resolveMultipart(request);
            } else if (multipartResolver instanceof StandardServletMultipartResolver) {
                multipartRequest = new StandardServletMultipartResolver().resolveMultipart(request);
            }
        }
        if (multipartRequest == null) {
            return map;
        }
        Iterator fileNames = multipartRequest.getFileNames();
        while (fileNames.hasNext()) {
            String fileName = (String)fileNames.next();
            map.put(fileName, multipartRequest.getFiles(fileName));
        }
        map.putAll(multipartRequest.getParameterMap());
        if (request instanceof ServletRequestWrapper && (childMultipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)((ServletRequestWrapper)request).getRequest(), MultipartHttpServletRequest.class)) != null) {
            map.putAll(MultipartFileUtil.getFileFormRequest((HttpServletRequest)childMultipartRequest));
        }
        return map;
    }

    public static boolean checkFileFormat(File file) {
        String format = PropertiesUtil.getProperty((String)"agile.upload.include_format");
        if (StringUtils.isEmpty((CharSequence)format)) {
            return true;
        }
        Object[] formats = format.split(",", -1);
        return ArrayUtils.contains((Object[])formats, (Object)FilenameUtils.getExtension((String)file.getName()));
    }

    public static ResponseEntity<byte[]> downloadFile(File file) throws FileNotFoundException {
        byte[] byteFile;
        try {
            byteFile = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentLength(file.length());
        headers.setContentDispositionFormData("attachment", new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        return new ResponseEntity((Object)byteFile, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public static ResponseEntity<byte[]> downloadFile(String filePath) throws FileNotFoundException {
        return MultipartFileUtil.downloadFile(new File(filePath));
    }

    public static String getTempPath() {
        boolean is;
        if (!StringUtil.isBlank((CharSequence)tempPath)) {
            return tempPath;
        }
        MultipartProperties properties = BeanUtil.getBean(MultipartProperties.class);
        String filePath = properties != null && properties.getLocation() != null ? properties.getLocation() : MultipartFileUtil.class.getResource("").getPath();
        File file = new File(filePath);
        if (!file.exists() && !(is = file.mkdirs())) {
            throw new RuntimeException("\u7f13\u5b58\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa");
        }
        try {
            tempPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!tempPath.endsWith(File.separator)) {
            tempPath = tempPath + File.separator;
        }
        return tempPath;
    }

    public static List<String> uploadFile(Collection<MultipartFile> files, String dirName) {
        return MultipartFileUtil.uploadFile(files, dirName, null);
    }

    public static List<String> uploadFile(Collection<MultipartFile> files, String dirName, String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return files.stream().map(file -> {
                try {
                    return MultipartFileUtil.uploadFile(file, dirName);
                }
                catch (CreateFileException | IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return IterablesUtil.map((Integer)1, files, (index, file) -> {
            try {
                return MultipartFileUtil.uploadFile(file, dirName, String.format("%s(%s)", fileName, index));
            }
            catch (CreateFileException | IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String uploadFile(MultipartFile file) throws CreateFileException, IOException {
        return MultipartFileUtil.uploadFile(file, null);
    }

    public static String uploadFile(MultipartFile file, String dirName) throws CreateFileException, IOException {
        return MultipartFileUtil.uploadFile(file, dirName, null);
    }

    public static String uploadFile(MultipartFile file, String dirName, String fileName) throws CreateFileException, IOException {
        String string = dirName = StringUtils.isEmpty((CharSequence)dirName) ? "" : dirName;
        if (FileUtil.isIllegalDirName((String)dirName)) {
            throw new RuntimeException("\u975e\u6cd5\u76ee\u5f55\u7ed3\u6784\uff0c\u5b58\u5728\u88ab\u653b\u51fb\u5a01\u80c1");
        }
        String dirPath = MultipartFileUtil.getTempPath() + dirName;
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new CreateFileException(dir.getAbsolutePath());
        }
        try {
            dirPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        fileName = StringUtils.isEmpty((CharSequence)fileName) ? file.getOriginalFilename() : fileName;
        String absoluteFileName = dirPath + fileName;
        File uploadFile = new File(absoluteFileName);
        if (!uploadFile.exists() && !uploadFile.createNewFile()) {
            throw new CreateFileException(absoluteFileName);
        }
        file.transferTo(uploadFile);
        return absoluteFileName;
    }

    public static File getFile(String fileName) throws FileNotFoundException {
        File file = fileName.startsWith(File.separator) ? new File(fileName) : new File(MultipartFileUtil.getTempPath() + fileName);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public static String toRelativePath(String absolutelyPath) {
        return absolutelyPath.replace(MultipartFileUtil.getTempPath(), "").replace(File.separator, "/");
    }
}

