/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.spring.util.ParamUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.MultipartResolutionDelegate;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

public class RequestWrapper
extends ContentCachingRequestWrapper {
    private final Map<String, String[]> parameters = Maps.newHashMap();
    private final Map<String, Object> inParam;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.parameters.putAll(request.getParameterMap());
        this.inParam = ParamUtil.handleInParamWithFile((HttpServletRequest)this);
    }

    public static RequestWrapper extract(HttpServletRequest request) {
        RequestWrapper r = (RequestWrapper)((Object)WebUtils.getNativeRequest((ServletRequest)request, RequestWrapper.class));
        if (r == null) {
            return new RequestWrapper(request);
        }
        return r;
    }

    public static boolean isWrapper(HttpServletRequest request) {
        return WebUtils.getNativeRequest((ServletRequest)request, RequestWrapper.class) != null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public void addParameter(String key, String o) {
        if (this.parameters.containsKey(key)) {
            Object[] value = this.parameters.get(key);
            this.parameters.put(key, (String[])ArrayUtils.add((Object[])value, (Object)o));
        }
        this.parameters.put(key, new String[]{o});
    }

    public Map<String, Object> getInParam() {
        return this.inParam;
    }

    public void extendInParam(Map<String, Object> params) {
        this.inParam.putAll(params);
    }

    public ServletInputStream getInputStream() throws IOException {
        final byte[] bytes = this.getContentAsByteArray();
        if (bytes.length > 0) {
            return new ServletInputStream(){
                final ByteArrayInputStream inputStream;
                {
                    this.inputStream = new ByteArrayInputStream(bytes);
                }

                public int read() {
                    return this.inputStream.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
        }
        return super.getInputStream();
    }

    public boolean containsKey(String key) {
        return ParamUtil.containsKey(this.getInParam(), key);
    }

    public Object getInParam(String key) {
        return ParamUtil.getInParam(this.getInParam(), key);
    }

    public <T> T getInParam(Class<T> clazz) {
        return ParamUtil.getInParam(this.getInParam(), clazz);
    }

    public <T> T getInParam(TypeReference<T> typeReference) {
        return ParamUtil.getInParam(this.getInParam(), typeReference);
    }

    public <T> T getInParamByPrefix(Class<T> clazz, String prefix) {
        return (T)ObjectUtil.getObjectFromMap(clazz, this.getInParam(), (String)prefix);
    }

    public <T> T getInParamByPrefixAndSuffix(Class<T> clazz, String prefix, String suffix) {
        return (T)ObjectUtil.getObjectFromMap(clazz, this.getInParam(), (String)prefix, (String)suffix);
    }

    public String getInParam(String key, String defaultValue) {
        return ParamUtil.getInParam(this.getInParam(), key, defaultValue);
    }

    public <T> T getInParam(String key, Class<T> clazz) {
        return ParamUtil.getInParam(this.getInParam(), key, clazz);
    }

    public <T> T getInParam(String key, TypeReference<T> reference) {
        return ParamUtil.getInParam(this.getInParam(), key, reference);
    }

    public <T> T getInParam(String key, Class<T> clazz, T defaultValue) {
        return ParamUtil.getInParam(this.getInParam(), key, clazz, defaultValue);
    }

    public MultipartFile getInParamOfFile(String key) {
        boolean isMultipart = MultipartResolutionDelegate.isMultipartRequest((HttpServletRequest)this);
        if (!isMultipart) {
            return null;
        }
        MultipartRequest multipartRequest = (MultipartRequest)WebUtils.getNativeRequest((ServletRequest)this, MultipartRequest.class);
        if (multipartRequest == null) {
            multipartRequest = new StandardMultipartHttpServletRequest((HttpServletRequest)this);
        }
        return multipartRequest.getFile(key);
    }

    public List<MultipartFile> getInParamOfFiles(String key) {
        boolean isMultipart = MultipartResolutionDelegate.isMultipartRequest((HttpServletRequest)this);
        if (!isMultipart) {
            return Lists.newArrayList();
        }
        MultipartRequest multipartRequest = (MultipartRequest)WebUtils.getNativeRequest((ServletRequest)this, MultipartRequest.class);
        if (multipartRequest == null) {
            multipartRequest = new StandardMultipartHttpServletRequest((HttpServletRequest)this);
        }
        return multipartRequest.getFiles(key);
    }

    public List<String> getInParamOfArray(String key) {
        return this.getInParamOfArray(key, String.class);
    }

    public <T> List<T> getInParamOfArray(String key, Class<T> clazz) {
        return ParamUtil.getInParamOfArray(this.getInParam(), key, clazz);
    }
}

