/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.BeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ViewUtil {
    private static List<ViewResolver> viewResolvers;
    private static Locale locale;
    private static RequestToViewNameTranslator viewNameTranslator;

    public static void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes(request, response));
        ApplicationContext context = BeanUtil.getApplicationContext();
        if (locale == null) {
            ViewUtil.initLocaleResolver(context, request);
        }
        if (viewResolvers == null) {
            ViewUtil.initViewResolvers(context);
        }
        if (viewNameTranslator == null) {
            ViewUtil.initRequestToViewNameTranslator(context);
        }
        response.setLocale(locale);
        String viewName = mv.getViewName();
        if (viewName == null) {
            viewName = ViewUtil.getDefaultViewName(request);
            mv.setViewName(viewName);
        }
        View view = ViewUtil.resolveViewName(viewName, mv.getModel(), locale, request);
        if (mv.getStatus() != null) {
            response.setStatus(mv.getStatus().value());
        }
        view.render(mv.getModel(), request, response);
    }

    private static View resolveViewName(String viewName, @Nullable Map<String, Object> model, Locale locale, HttpServletRequest request) throws Exception {
        if (viewResolvers != null) {
            for (ViewResolver viewResolver : viewResolvers) {
                View view = viewResolver.resolveViewName(viewName, locale);
                if (view == null) continue;
                return view;
            }
        }
        throw new RuntimeException("No views were found!");
    }

    private static void initLocaleResolver(ApplicationContext context, HttpServletRequest request) throws IOException {
        List<LocaleResolver> localeResolvers = ViewUtil.getDefaultStrategies(context, LocaleResolver.class);
        locale = !localeResolvers.isEmpty() ? localeResolvers.get(0).resolveLocale(request) : request.getLocale();
    }

    private static void initViewResolvers(ApplicationContext context) throws IOException {
        viewResolvers = null;
        Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ViewResolver.class, (boolean)true, (boolean)false);
        if (!matchingBeans.isEmpty()) {
            viewResolvers = new LinkedList(matchingBeans.values());
            AnnotationAwareOrderComparator.sort(viewResolvers);
        }
        if (viewResolvers == null) {
            viewResolvers = ViewUtil.getDefaultStrategies(context, ViewResolver.class);
        }
    }

    private static void initRequestToViewNameTranslator(ApplicationContext context) throws IOException {
        try {
            viewNameTranslator = (RequestToViewNameTranslator)context.getBean("viewNameTranslator", RequestToViewNameTranslator.class);
        }
        catch (NoSuchBeanDefinitionException var3) {
            viewNameTranslator = ViewUtil.getDefaultStrategies(context, RequestToViewNameTranslator.class).get(0);
        }
    }

    private static <T> List<T> getDefaultStrategies(ApplicationContext context, Class<T> strategyInterface) throws IOException {
        String key = strategyInterface.getName();
        ClassPathResource resource = new ClassPathResource("DispatcherServlet.properties", DispatcherServlet.class);
        Properties defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        String value = defaultStrategies.getProperty(key);
        if (value == null) {
            return new LinkedList();
        }
        String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<Object> strategies = new ArrayList<Object>(classNames.length);
        for (String className : classNames) {
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)DispatcherServlet.class.getClassLoader());
                Object strategy = context.getAutowireCapableBeanFactory().createBean(clazz);
                strategies.add(strategy);
            }
            catch (ClassNotFoundException var13) {
                throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)var13);
            }
            catch (LinkageError var14) {
                throw new BeanInitializationException("Unresolvable class definition for DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)var14);
            }
        }
        return strategies;
    }

    @Nullable
    private static String getDefaultViewName(HttpServletRequest request) throws Exception {
        return viewNameTranslator != null ? viewNameTranslator.getViewName(request) : null;
    }
}

