package cloud.agileframework.spring.sync;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;

/**
 * 确保应用退出时能关闭后台线程
 *
 * @author mydeathtrial
 */
@Component
public class ShutdownManager {
    private static final Logger LOGGER = LoggerFactory.getLogger("sys-user");

    @PreDestroy
    public void destroy() {
        shutdownAsyncManager();
    }

    /**
     * 停止异步执行任务
     */
    private void shutdownAsyncManager() {
        try {
            LOGGER.info("====关闭后台任务任务线程池====");
            AsyncManager.shutdown();
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }
}
