/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.AggregatesHistogramResponse;
import cloud.artik.model.AggregatesResponse;
import cloud.artik.model.FieldPresenceEnvelope;
import cloud.artik.model.MessageAction;
import cloud.artik.model.MessageIDEnvelope;
import cloud.artik.model.NormalizedMessagesEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class MessagesApi {
    private ApiClient apiClient;

    public MessagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getNormalizedMessagesCall(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "uid", uid));
        }
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (mid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "mid", mid));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public NormalizedMessagesEnvelope getNormalizedMessages(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = this.getNormalizedMessagesWithHttpInfo(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order);
        return resp.getData();
    }

    public ApiResponse<NormalizedMessagesEnvelope> getNormalizedMessagesWithHttpInfo(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        Call call = this.getNormalizedMessagesCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNormalizedMessagesAsync(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNormalizedMessagesCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call sendMessageActionCall(MessageAction data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MessageAction localVarPostBody = data;
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendMessageAction(Async)");
        }
        String localVarPath = "/messages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public MessageIDEnvelope sendMessageAction(MessageAction data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = this.sendMessageActionWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<MessageIDEnvelope> sendMessageActionWithHttpInfo(MessageAction data) throws ApiException {
        Call call = this.sendMessageActionCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendMessageActionAsync(MessageAction data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendMessageActionCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMessageAggregatesCall(String sdid, String field, Long startDate, Long endDate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (sdid == null) {
            throw new ApiException("Missing the required parameter 'sdid' when calling getMessageAggregates(Async)");
        }
        if (field == null) {
            throw new ApiException("Missing the required parameter 'field' when calling getMessageAggregates(Async)");
        }
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getMessageAggregates(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getMessageAggregates(Async)");
        }
        String localVarPath = "/messages/analytics/aggregates".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (field != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "field", field));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public AggregatesResponse getMessageAggregates(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        ApiResponse<AggregatesResponse> resp = this.getMessageAggregatesWithHttpInfo(sdid, field, startDate, endDate);
        return resp.getData();
    }

    public ApiResponse<AggregatesResponse> getMessageAggregatesWithHttpInfo(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        Call call = this.getMessageAggregatesCall(sdid, field, startDate, endDate, null, null);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMessageAggregatesAsync(String sdid, String field, Long startDate, Long endDate, final ApiCallback<AggregatesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMessageAggregatesCall(sdid, field, startDate, endDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAggregatesHistogramCall(Long startDate, Long endDate, String sdid, String field, String interval, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getAggregatesHistogram(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getAggregatesHistogram(Async)");
        }
        String localVarPath = "/messages/analytics/histogram".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (field != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "field", field));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public AggregatesHistogramResponse getAggregatesHistogram(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        ApiResponse<AggregatesHistogramResponse> resp = this.getAggregatesHistogramWithHttpInfo(startDate, endDate, sdid, field, interval);
        return resp.getData();
    }

    public ApiResponse<AggregatesHistogramResponse> getAggregatesHistogramWithHttpInfo(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        Call call = this.getAggregatesHistogramCall(startDate, endDate, sdid, field, interval, null, null);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAggregatesHistogramAsync(Long startDate, Long endDate, String sdid, String field, String interval, final ApiCallback<AggregatesHistogramResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAggregatesHistogramCall(startDate, endDate, sdid, field, interval, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getLastNormalizedMessagesCall(Integer count, String sdids, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/last".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (sdids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdids", sdids));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public NormalizedMessagesEnvelope getLastNormalizedMessages(Integer count, String sdids, String fieldPresence) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = this.getLastNormalizedMessagesWithHttpInfo(count, sdids, fieldPresence);
        return resp.getData();
    }

    public ApiResponse<NormalizedMessagesEnvelope> getLastNormalizedMessagesWithHttpInfo(Integer count, String sdids, String fieldPresence) throws ApiException {
        Call call = this.getLastNormalizedMessagesCall(count, sdids, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLastNormalizedMessagesAsync(Integer count, String sdids, String fieldPresence, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLastNormalizedMessagesCall(count, sdids, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getFieldPresenceCall(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getFieldPresence(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getFieldPresence(Async)");
        }
        if (interval == null) {
            throw new ApiException("Missing the required parameter 'interval' when calling getFieldPresence(Async)");
        }
        String localVarPath = "/messages/presence".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public FieldPresenceEnvelope getFieldPresence(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        ApiResponse<FieldPresenceEnvelope> resp = this.getFieldPresenceWithHttpInfo(startDate, endDate, interval, sdid, fieldPresence);
        return resp.getData();
    }

    public ApiResponse<FieldPresenceEnvelope> getFieldPresenceWithHttpInfo(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        Call call = this.getFieldPresenceCall(startDate, endDate, interval, sdid, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFieldPresenceAsync(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ApiCallback<FieldPresenceEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFieldPresenceCall(startDate, endDate, interval, sdid, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

