/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.RuleCreationInfo;
import cloud.artik.model.RuleEnvelope;
import cloud.artik.model.RuleUpdateInfo;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RulesApi {
    private ApiClient apiClient;

    public RulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RulesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createRuleCall(RuleCreationInfo ruleInfo, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleCreationInfo localVarPostBody = ruleInfo;
        if (ruleInfo == null) {
            throw new ApiException("Missing the required parameter 'ruleInfo' when calling createRule(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createRule(Async)");
        }
        String localVarPath = "/rules".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (userId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "userId", userId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public RuleEnvelope createRule(RuleCreationInfo ruleInfo, String userId) throws ApiException {
        ApiResponse<RuleEnvelope> resp = this.createRuleWithHttpInfo(ruleInfo, userId);
        return resp.getData();
    }

    public ApiResponse<RuleEnvelope> createRuleWithHttpInfo(RuleCreationInfo ruleInfo, String userId) throws ApiException {
        Call call = this.createRuleCall(ruleInfo, userId, null, null);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createRuleAsync(RuleCreationInfo ruleInfo, String userId, final ApiCallback<RuleEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createRuleCall(ruleInfo, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getRuleCall(String ruleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling getRule(Async)");
        }
        String localVarPath = "/rules/{ruleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public RuleEnvelope getRule(String ruleId) throws ApiException {
        ApiResponse<RuleEnvelope> resp = this.getRuleWithHttpInfo(ruleId);
        return resp.getData();
    }

    public ApiResponse<RuleEnvelope> getRuleWithHttpInfo(String ruleId) throws ApiException {
        Call call = this.getRuleCall(ruleId, null, null);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRuleAsync(String ruleId, final ApiCallback<RuleEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRuleCall(ruleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateRuleCall(String ruleId, RuleUpdateInfo ruleInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RuleUpdateInfo localVarPostBody = ruleInfo;
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling updateRule(Async)");
        }
        if (ruleInfo == null) {
            throw new ApiException("Missing the required parameter 'ruleInfo' when calling updateRule(Async)");
        }
        String localVarPath = "/rules/{ruleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public RuleEnvelope updateRule(String ruleId, RuleUpdateInfo ruleInfo) throws ApiException {
        ApiResponse<RuleEnvelope> resp = this.updateRuleWithHttpInfo(ruleId, ruleInfo);
        return resp.getData();
    }

    public ApiResponse<RuleEnvelope> updateRuleWithHttpInfo(String ruleId, RuleUpdateInfo ruleInfo) throws ApiException {
        Call call = this.updateRuleCall(ruleId, ruleInfo, null, null);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateRuleAsync(String ruleId, RuleUpdateInfo ruleInfo, final ApiCallback<RuleEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateRuleCall(ruleId, ruleInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteRuleCall(String ruleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling deleteRule(Async)");
        }
        String localVarPath = "/rules/{ruleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public RuleEnvelope deleteRule(String ruleId) throws ApiException {
        ApiResponse<RuleEnvelope> resp = this.deleteRuleWithHttpInfo(ruleId);
        return resp.getData();
    }

    public ApiResponse<RuleEnvelope> deleteRuleWithHttpInfo(String ruleId) throws ApiException {
        Call call = this.deleteRuleCall(ruleId, null, null);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteRuleAsync(String ruleId, final ApiCallback<RuleEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteRuleCall(ruleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

