/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.AppProperties;
import cloud.artik.model.DeviceTypesEnvelope;
import cloud.artik.model.DevicesEnvelope;
import cloud.artik.model.PropertiesEnvelope;
import cloud.artik.model.RulesEnvelope;
import cloud.artik.model.UserEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createUserPropertiesCall(String userId, AppProperties properties, String aid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppProperties localVarPostBody = properties;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserProperties(Async)");
        }
        if (properties == null) {
            throw new ApiException("Missing the required parameter 'properties' when calling createUserProperties(Async)");
        }
        String localVarPath = "/users/{userId}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (aid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aid", aid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public PropertiesEnvelope createUserProperties(String userId, AppProperties properties, String aid) throws ApiException {
        ApiResponse<PropertiesEnvelope> resp = this.createUserPropertiesWithHttpInfo(userId, properties, aid);
        return resp.getData();
    }

    public ApiResponse<PropertiesEnvelope> createUserPropertiesWithHttpInfo(String userId, AppProperties properties, String aid) throws ApiException {
        Call call = this.createUserPropertiesCall(userId, properties, aid, null, null);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createUserPropertiesAsync(String userId, AppProperties properties, String aid, final ApiCallback<PropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createUserPropertiesCall(userId, properties, aid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteUserPropertiesCall(String userId, String aid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserProperties(Async)");
        }
        String localVarPath = "/users/{userId}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (aid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aid", aid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public PropertiesEnvelope deleteUserProperties(String userId, String aid) throws ApiException {
        ApiResponse<PropertiesEnvelope> resp = this.deleteUserPropertiesWithHttpInfo(userId, aid);
        return resp.getData();
    }

    public ApiResponse<PropertiesEnvelope> deleteUserPropertiesWithHttpInfo(String userId, String aid) throws ApiException {
        Call call = this.deleteUserPropertiesCall(userId, aid, null, null);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteUserPropertiesAsync(String userId, String aid, final ApiCallback<PropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUserPropertiesCall(userId, aid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getSelfCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/self".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public UserEnvelope getSelf() throws ApiException {
        ApiResponse<UserEnvelope> resp = this.getSelfWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<UserEnvelope> getSelfWithHttpInfo() throws ApiException {
        Call call = this.getSelfCall(null, null);
        Type localVarReturnType = new TypeToken<UserEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSelfAsync(final ApiCallback<UserEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSelfCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUserDeviceTypesCall(String userId, Integer offset, Integer count, Boolean includeShared, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserDeviceTypes(Async)");
        }
        String localVarPath = "/users/{userId}/devicetypes".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (includeShared != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeShared", includeShared));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DeviceTypesEnvelope getUserDeviceTypes(String userId, Integer offset, Integer count, Boolean includeShared) throws ApiException {
        ApiResponse<DeviceTypesEnvelope> resp = this.getUserDeviceTypesWithHttpInfo(userId, offset, count, includeShared);
        return resp.getData();
    }

    public ApiResponse<DeviceTypesEnvelope> getUserDeviceTypesWithHttpInfo(String userId, Integer offset, Integer count, Boolean includeShared) throws ApiException {
        Call call = this.getUserDeviceTypesCall(userId, offset, count, includeShared, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserDeviceTypesAsync(String userId, Integer offset, Integer count, Boolean includeShared, final ApiCallback<DeviceTypesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserDeviceTypesCall(userId, offset, count, includeShared, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUserDevicesCall(String userId, Integer offset, Integer count, Boolean includeProperties, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserDevices(Async)");
        }
        String localVarPath = "/users/{userId}/devices".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (includeProperties != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeProperties", includeProperties));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DevicesEnvelope getUserDevices(String userId, Integer offset, Integer count, Boolean includeProperties) throws ApiException {
        ApiResponse<DevicesEnvelope> resp = this.getUserDevicesWithHttpInfo(userId, offset, count, includeProperties);
        return resp.getData();
    }

    public ApiResponse<DevicesEnvelope> getUserDevicesWithHttpInfo(String userId, Integer offset, Integer count, Boolean includeProperties) throws ApiException {
        Call call = this.getUserDevicesCall(userId, offset, count, includeProperties, null, null);
        Type localVarReturnType = new TypeToken<DevicesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserDevicesAsync(String userId, Integer offset, Integer count, Boolean includeProperties, final ApiCallback<DevicesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserDevicesCall(userId, offset, count, includeProperties, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DevicesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUserPropertiesCall(String userId, String aid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserProperties(Async)");
        }
        String localVarPath = "/users/{userId}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (aid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aid", aid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public PropertiesEnvelope getUserProperties(String userId, String aid) throws ApiException {
        ApiResponse<PropertiesEnvelope> resp = this.getUserPropertiesWithHttpInfo(userId, aid);
        return resp.getData();
    }

    public ApiResponse<PropertiesEnvelope> getUserPropertiesWithHttpInfo(String userId, String aid) throws ApiException {
        Call call = this.getUserPropertiesCall(userId, aid, null, null);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserPropertiesAsync(String userId, String aid, final ApiCallback<PropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserPropertiesCall(userId, aid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUserRulesCall(String userId, Boolean excludeDisabled, Integer count, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserRules(Async)");
        }
        String localVarPath = "/users/{userId}/rules".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (excludeDisabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "excludeDisabled", excludeDisabled));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public RulesEnvelope getUserRules(String userId, Boolean excludeDisabled, Integer count, Integer offset) throws ApiException {
        ApiResponse<RulesEnvelope> resp = this.getUserRulesWithHttpInfo(userId, excludeDisabled, count, offset);
        return resp.getData();
    }

    public ApiResponse<RulesEnvelope> getUserRulesWithHttpInfo(String userId, Boolean excludeDisabled, Integer count, Integer offset) throws ApiException {
        Call call = this.getUserRulesCall(userId, excludeDisabled, count, offset, null, null);
        Type localVarReturnType = new TypeToken<RulesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserRulesAsync(String userId, Boolean excludeDisabled, Integer count, Integer offset, final ApiCallback<RulesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserRulesCall(userId, excludeDisabled, count, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RulesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateUserPropertiesCall(String userId, AppProperties properties, String aid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppProperties localVarPostBody = properties;
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateUserProperties(Async)");
        }
        if (properties == null) {
            throw new ApiException("Missing the required parameter 'properties' when calling updateUserProperties(Async)");
        }
        String localVarPath = "/users/{userId}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (aid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aid", aid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public PropertiesEnvelope updateUserProperties(String userId, AppProperties properties, String aid) throws ApiException {
        ApiResponse<PropertiesEnvelope> resp = this.updateUserPropertiesWithHttpInfo(userId, properties, aid);
        return resp.getData();
    }

    public ApiResponse<PropertiesEnvelope> updateUserPropertiesWithHttpInfo(String userId, AppProperties properties, String aid) throws ApiException {
        Call call = this.updateUserPropertiesCall(userId, properties, aid, null, null);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateUserPropertiesAsync(String userId, AppProperties properties, String aid, final ApiCallback<PropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateUserPropertiesCall(userId, properties, aid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

