/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bungee;

import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.bungee.BungeeCommandManager;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.plugin.TabExecutor;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BungeeCommand<C>
extends net.md_5.bungee.api.plugin.Command
implements TabExecutor {
    private static final String MESSAGE_INTERNAL_ERROR = "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final BungeeCommandManager<C> manager;
    private final CommandArgument<C, ?> command;

    BungeeCommand(@NonNull Command<C> cloudCommand, @NonNull CommandArgument<C, ?> command, @NonNull BungeeCommandManager<C> manager) {
        super(command.getName(), cloudCommand.getCommandPermission().toString(), ((StaticArgument)command).getAlternativeAliases().toArray(new String[0]));
        this.command = command;
        this.manager = manager;
    }

    public void execute(CommandSender commandSender, String[] strings) {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        C sender = this.manager.getCommandSenderMapper().apply(commandSender);
        this.manager.executeCommand(sender, builder.toString()).whenComplete((commandResult, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(sender, InvalidSyntaxException.class, (Exception)((InvalidSyntaxException)throwable), (c, e) -> commandSender.sendMessage(new ComponentBuilder("Invalid Command Syntax. Correct command syntax is: ").color(ChatColor.RED).append("/").color(ChatColor.GRAY).append(((InvalidSyntaxException)finalThrowable).getCorrectSyntax()).color(ChatColor.GRAY).create()));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    Throwable finalThrowable1 = throwable;
                    this.manager.handleException(sender, InvalidCommandSenderException.class, (Exception)((InvalidCommandSenderException)throwable), (c, e) -> commandSender.sendMessage(new ComponentBuilder(finalThrowable1.getMessage()).color(ChatColor.RED).create()));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(sender, NoPermissionException.class, (Exception)((NoPermissionException)throwable), (c, e) -> commandSender.sendMessage(new ComponentBuilder(MESSAGE_NO_PERMS).color(ChatColor.WHITE).create()));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(sender, NoSuchCommandException.class, (Exception)((NoSuchCommandException)throwable), (c, e) -> commandSender.sendMessage(new ComponentBuilder(MESSAGE_UNKNOWN_COMMAND).color(ChatColor.WHITE).create()));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(sender, ArgumentParseException.class, (Exception)((ArgumentParseException)throwable), (c, e) -> commandSender.sendMessage(new ComponentBuilder("Invalid Command Argument: ").color(ChatColor.GRAY).append(finalThrowable.getCause().getMessage()).create()));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(sender, CommandExecutionException.class, (Exception)((CommandExecutionException)throwable), (c, e) -> {
                        commandSender.sendMessage(new ComponentBuilder(MESSAGE_INTERNAL_ERROR).color(ChatColor.RED).create());
                        this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "Exception executing command handler", finalThrowable.getCause());
                    });
                } else {
                    commandSender.sendMessage(new ComponentBuilder(MESSAGE_INTERNAL_ERROR).color(ChatColor.RED).create());
                    this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "An unhandled exception was thrown during command execution", (Throwable)throwable);
                }
            }
        });
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : args) {
            builder.append(" ").append(string);
        }
        return this.manager.suggest(this.manager.getCommandSenderMapper().apply(sender), builder.toString());
    }
}

