/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bungee.arguments;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bungee.BungeeCaptionKeys;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlayerArgument<C>
extends CommandArgument<C, ProxiedPlayer> {
    private PlayerArgument(boolean required, @NonNull String name, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionProvider, @NonNull ArgumentDescription defaultDescription, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new PlayerParser(), "", TypeToken.get(ProxiedPlayer.class), suggestionProvider, defaultDescription, argumentPreprocessors);
    }

    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandArgument.Builder<C, ProxiedPlayer> newBuilder(@NonNull String name) {
        return new Builder(name).withParser(new PlayerParser());
    }

    public static <C> CommandArgument<C, ProxiedPlayer> of(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> CommandArgument<C, ProxiedPlayer> optional(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asOptional().build();
    }

    public static final class PlayerParseException
    extends ParserException {
        private static final long serialVersionUID = -2685136673577959929L;

        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }

    public static final class PlayerParser<C>
    implements ArgumentParser<C, ProxiedPlayer> {
        public @NonNull ArgumentParseResult<@NonNull ProxiedPlayer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(PlayerParser.class, commandContext));
            }
            ProxiedPlayer player = ((ProxyServer)commandContext.get("ProxyServer")).getPlayer(input);
            if (player == null) {
                return ArgumentParseResult.failure((Throwable)((Object)new PlayerParseException(input, commandContext)));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)player);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return ((ProxyServer)commandContext.get("ProxyServer")).getPlayers().stream().map(ProxiedPlayer::getDisplayName).collect(Collectors.toList());
        }

        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, ProxiedPlayer> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(ProxiedPlayer.class), name);
        }

        public @NonNull CommandArgument<@NonNull C, @NonNull ProxiedPlayer> build() {
            return new PlayerArgument(this.isRequired(), this.getName(), this.getSuggestionsProvider(), this.getDefaultDescription(), new LinkedList());
        }
    }
}

