/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.pircbotx;

import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.pircbotx.PircBotXCommandManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.types.GenericMessageEvent;

final class CloudListenerAdapter<C>
extends ListenerAdapter {
    private static final String MESSAGE_INTERNAL_ERROR = "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_INVALID_SYNTAX = "Invalid Command Syntax. Correct command syntax is: ";
    private static final String MESSAGE_NO_PERMS = "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command";
    private final PircBotXCommandManager<C> manager;

    CloudListenerAdapter(@NonNull PircBotXCommandManager<C> manager) {
        this.manager = manager;
    }

    public void onGenericMessage(@NonNull GenericMessageEvent event) {
        String message = event.getMessage();
        if (!message.startsWith(this.manager.getCommandPrefix())) {
            return;
        }
        C sender = this.manager.getUserMapper().apply(event.getUser());
        this.manager.executeCommand(sender, message.substring(this.manager.getCommandPrefix().length())).whenComplete((commandResult, throwable) -> {
            if (throwable == null) {
                return;
            }
            Throwable finalThrowable = throwable;
            if (throwable instanceof InvalidSyntaxException) {
                this.manager.handleException(sender, InvalidSyntaxException.class, (Exception)((InvalidSyntaxException)throwable), (c, e) -> event.respondWith(MESSAGE_INVALID_SYNTAX + this.manager.getCommandPrefix() + ((InvalidSyntaxException)throwable).getCorrectSyntax()));
            } else if (throwable instanceof InvalidCommandSenderException) {
                this.manager.handleException(sender, InvalidCommandSenderException.class, (Exception)((InvalidCommandSenderException)throwable), (c, e) -> event.respondWith(throwable.getMessage()));
            } else if (throwable instanceof NoPermissionException) {
                this.manager.handleException(sender, NoPermissionException.class, (Exception)((NoPermissionException)throwable), (c, e) -> event.respondWith(MESSAGE_NO_PERMS));
            } else if (throwable instanceof NoSuchCommandException) {
                this.manager.handleException(sender, NoSuchCommandException.class, (Exception)((NoSuchCommandException)throwable), (c, e) -> event.respondWith(MESSAGE_UNKNOWN_COMMAND));
            } else if (throwable instanceof ArgumentParseException) {
                this.manager.handleException(sender, ArgumentParseException.class, (Exception)((ArgumentParseException)throwable), (c, e) -> event.respondWith("Invalid Command Argument: " + throwable.getCause().getMessage()));
            } else if (throwable instanceof CommandExecutionException) {
                this.manager.handleException(sender, CommandExecutionException.class, (Exception)((CommandExecutionException)throwable), (c, e) -> {
                    event.respondWith(MESSAGE_INTERNAL_ERROR);
                    finalThrowable.getCause().printStackTrace();
                });
            } else {
                event.respondWith(throwable.getMessage());
            }
        });
    }
}

