/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.pircbotx;

import cloud.commandframework.CloudCapability;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.captions.Caption;
import cloud.commandframework.captions.FactoryDelegatingCaptionRegistry;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.internal.CommandRegistrationHandler;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.pircbotx.CloudListenerAdapter;
import cloud.commandframework.pircbotx.arguments.UserArgument;
import io.leangen.geantyref.TypeToken;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;

public class PircBotXCommandManager<C>
extends CommandManager<C> {
    public static final String PIRCBOTX_META_KEY = "__internal_pircbotx__";
    public static final Caption ARGUMENT_PARSE_FAILURE_USER_KEY = Caption.of((String)"argument.parse.failure.use");
    public static final String ARGUMENT_PARSE_FAILURE_USER = "'{input}' is not a valid user";
    private final String commandPrefix;
    private final BiFunction<C, String, Boolean> permissionFunction;
    private final Function<User, C> userMapper;
    private final PircBotX pircBotX;

    public PircBotXCommandManager(@NonNull PircBotX pircBotX, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull CommandRegistrationHandler commandRegistrationHandler, @NonNull BiFunction<C, String, Boolean> permissionFunction, @NonNull Function<User, C> userMapper, @NonNull String commandPrefix) {
        super(commandExecutionCoordinator, commandRegistrationHandler);
        this.pircBotX = pircBotX;
        this.permissionFunction = permissionFunction;
        this.commandPrefix = commandPrefix;
        this.userMapper = userMapper;
        this.pircBotX.getConfiguration().getListenerManager().addListener(new CloudListenerAdapter(this));
        if (this.captionRegistry() instanceof FactoryDelegatingCaptionRegistry) {
            ((FactoryDelegatingCaptionRegistry)this.captionRegistry()).registerMessageFactory(ARGUMENT_PARSE_FAILURE_USER_KEY, (caption, user) -> ARGUMENT_PARSE_FAILURE_USER);
        }
        this.registerCommandPreProcessor(context -> context.getCommandContext().store(PIRCBOTX_META_KEY, (Object)pircBotX));
        this.parserRegistry().registerParserSupplier(TypeToken.get(User.class), parameters -> new UserArgument.UserArgumentParser());
        this.registerCapability((CloudCapability)CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.permissionFunction.apply(sender, permission);
    }

    public final @NonNull CommandMeta createDefaultCommandMeta() {
        return CommandMeta.simple().build();
    }

    public final @NonNull String getCommandPrefix() {
        return this.commandPrefix;
    }

    final @NonNull Function<User, C> getUserMapper() {
        return this.userMapper;
    }
}

