/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.pircbotx.arguments;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import cloud.commandframework.pircbotx.PircBotXCommandManager;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.exception.DaoException;

public final class UserArgument<C>
extends CommandArgument<C, User> {
    private UserArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new UserArgumentParser(), defaultValue, TypeToken.get(User.class), suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return UserArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, User> of(@NonNull String name) {
        return UserArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, User> optional(@NonNull String name) {
        return UserArgument.builder(name).asOptional().build();
    }

    public static final class UserArgumentParser<C>
    implements ArgumentParser<C, User> {
        public @NonNull ArgumentParseResult<@NonNull User> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            User user;
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(UserArgumentParser.class, commandContext));
            }
            PircBotX pircBotX = (PircBotX)commandContext.get("__internal_pircbotx__");
            try {
                user = pircBotX.getUserChannelDao().getUser(input);
                inputQueue.remove();
            }
            catch (DaoException exception) {
                return ArgumentParseResult.failure((Throwable)((Object)new UserParseException(commandContext, input)));
            }
            return ArgumentParseResult.success((Object)user);
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, User> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(User.class), name);
        }

        public @NonNull CommandArgument<@NonNull C, @NonNull User> build() {
            return new UserArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class UserParseException
    extends ParserException {
        private static final long serialVersionUID = -1758590697299611905L;

        private UserParseException(@NonNull CommandContext<?> context, @NonNull String input) {
            super(UserArgumentParser.class, context, PircBotXCommandManager.ARGUMENT_PARSE_FAILURE_USER_KEY, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }
}

