/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.velocity;

import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.meta.SimpleCommandMeta;
import cloud.commandframework.velocity.VelocityPluginRegistrationHandler;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VelocityCommandManager<C>
extends CommandManager<C> {
    private final ProxyServer proxyServer;
    private final Function<CommandSource, C> commandSenderMapper;
    private final Function<C, CommandSource> backwardsCommandSenderMapper;

    public VelocityCommandManager(@NonNull ProxyServer proxyServer, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSource, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper) {
        super(commandExecutionCoordinator, new VelocityPluginRegistrationHandler());
        ((VelocityPluginRegistrationHandler)this.getCommandRegistrationHandler()).initialize(this);
        this.proxyServer = proxyServer;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    public final @NonNull CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    final @NonNull ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    final @NonNull Function<@NonNull CommandSource, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }
}

