/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.velocity;

import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.execution.CommandResult;
import cloud.commandframework.velocity.VelocityCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.CommandSource;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;

final class VelocityExecutor<C>
implements Command<CommandSource> {
    private static final String MESSAGE_INTERNAL_ERROR = "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final VelocityCommandManager<C> manager;

    VelocityExecutor(@NonNull VelocityCommandManager<C> commandManager) {
        this.manager = commandManager;
    }

    public int run(@NonNull CommandContext<CommandSource> commandContext) {
        CommandSource source = (CommandSource)commandContext.getSource();
        String input = commandContext.getInput();
        C sender = this.manager.commandSenderMapper().apply(source);
        this.manager.executeCommand(sender, input).whenComplete(this.getResultConsumer(source, sender));
        return 1;
    }

    private @NonNull BiConsumer<@NonNull CommandResult<C>, ? super Throwable> getResultConsumer(@NonNull CommandSource source, @NonNull C sender) {
        return (result, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(sender, InvalidSyntaxException.class, (Exception)((InvalidSyntaxException)throwable), (c, e) -> source.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Invalid Command Syntax. Correct command syntax is: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)e.getCorrectSyntax(), (TextColor)NamedTextColor.GRAY))).build()));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    this.manager.handleException(sender, InvalidCommandSenderException.class, (Exception)((InvalidCommandSenderException)throwable), (c, e) -> source.sendMessage(Identity.nil(), (Component)Component.text((String)finalThrowable.getMessage(), (TextColor)NamedTextColor.RED)));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(sender, NoPermissionException.class, (Exception)((NoPermissionException)throwable), (c, e) -> source.sendMessage(Identity.nil(), (Component)Component.text((String)MESSAGE_NO_PERMS)));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(sender, NoSuchCommandException.class, (Exception)((NoSuchCommandException)throwable), (c, e) -> source.sendMessage(Identity.nil(), (Component)Component.text((String)MESSAGE_UNKNOWN_COMMAND)));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(sender, ArgumentParseException.class, (Exception)((ArgumentParseException)throwable), (c, e) -> source.sendMessage(Identity.nil(), (ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Invalid Command Argument: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)finalThrowable.getCause().getMessage(), (TextColor)NamedTextColor.GRAY))));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(sender, CommandExecutionException.class, (Exception)((CommandExecutionException)throwable), (c, e) -> {
                        source.sendMessage(Identity.nil(), (Component)Component.text((String)MESSAGE_INTERNAL_ERROR, (TextColor)NamedTextColor.RED));
                        finalThrowable.getCause().printStackTrace();
                    });
                } else {
                    source.sendMessage(Identity.nil(), (Component)Component.text((String)MESSAGE_INTERNAL_ERROR, (TextColor)NamedTextColor.RED));
                    throwable.printStackTrace();
                }
            }
        };
    }
}

