/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.velocity;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.internal.CommandRegistrationHandler;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.velocity.VelocityCommandManager;
import cloud.commandframework.velocity.VelocityExecutor;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

final class VelocityPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private CloudBrigadierManager<C, CommandSource> brigadierManager;
    private VelocityCommandManager<C> manager;

    VelocityPluginRegistrationHandler() {
    }

    void initialize(@NonNull VelocityCommandManager<C> velocityCommandManager) {
        this.manager = velocityCommandManager;
        this.brigadierManager = new CloudBrigadierManager(velocityCommandManager, () -> new CommandContext(velocityCommandManager.commandSenderMapper().apply((CommandSource)velocityCommandManager.proxyServer().getConsoleCommandSource()), (CommandManager)velocityCommandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.manager.commandSenderMapper().apply((CommandSource)sender));
        this.brigadierManager.backwardsBrigadierSenderMapper(this.manager.backwardsCommandSenderMapper());
    }

    public boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument argument = (CommandArgument)command.getArguments().get(0);
        List aliases = ((StaticArgument)argument).getAlternativeAliases();
        BrigadierCommand brigadierCommand = new BrigadierCommand(this.brigadierManager.createLiteralCommandNode(((CommandArgument)command.getArguments().get(0)).getName(), command, (c, p) -> this.manager.hasPermission(this.manager.commandSenderMapper().apply((CommandSource)c), (CommandPermission)p), true, new VelocityExecutor<C>(this.manager)));
        CommandMeta commandMeta = this.manager.proxyServer().getCommandManager().metaBuilder(brigadierCommand).aliases(aliases.toArray(new String[0])).build();
        aliases.forEach(arg_0 -> ((com.velocitypowered.api.command.CommandManager)this.manager.proxyServer().getCommandManager()).unregister(arg_0));
        this.manager.proxyServer().getCommandManager().register(commandMeta, (com.velocitypowered.api.command.Command)brigadierCommand);
        return true;
    }

    @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return this.brigadierManager;
    }
}

