/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderCandle;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTick;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.util.Js;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HistoricalMarketDataClient
extends MetaApiClient {
    public HistoricalMarketDataClient(HttpClient httpClient, String token, String region, String domain) {
        super(httpClient, token, domain);
        region = (String)Js.or((Object[])new String[]{region, "new-york"});
        if (region != null) {
            List<String> domainLevels = Arrays.asList(domain.split("\\."));
            domain = String.join((CharSequence)".", domainLevels.subList(1, domainLevels.size()));
            this.host = "https://mt-market-data-client-api-v1." + region + "." + domain;
        } else {
            this.host = "https://mt-market-data-client-api-v1." + domain;
        }
    }

    public CompletableFuture<List<MetatraderCandle>> getHistoricalCandles(String accountId, String symbol, String timeframe, IsoTime startTime, Integer limit) {
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/historical-market-data/symbols/" + symbol + "/timeframes/" + timeframe + "/candles", HttpRequestOptions.Method.GET);
        if (startTime != null) {
            opts.getQueryParameters().put("startTime", startTime);
        }
        if (limit != null) {
            opts.getQueryParameters().put("limit", limit);
        }
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, MetatraderCandle[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<List<MetatraderTick>> getHistoricalTicks(String accountId, String symbol, IsoTime startTime, Integer offset, Integer limit) {
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/historical-market-data/symbols/" + symbol + "/ticks", HttpRequestOptions.Method.GET);
        if (startTime != null) {
            opts.getQueryParameters().put("startTime", startTime);
        }
        if (offset != null) {
            opts.getQueryParameters().put("offset", offset);
        }
        if (limit != null) {
            opts.getQueryParameters().put("limit", limit);
        }
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, MetatraderTick[].class).thenApply(array -> Arrays.asList(array));
    }
}

