/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.OptionsValidator;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.util.JsonMapper;
import cloud.metaapi.sdk.util.ServiceProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketLogger {
    private static SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static SimpleDateFormat shortDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static Logger logger = LogManager.getLogger(PacketLogger.class);
    private int fileNumberLimit;
    private int logFileSizeInHours;
    private boolean compressSpecifications;
    private boolean compressPrices;
    private Map<String, Map<Integer, PreviousPrice>> previousPrices = new ConcurrentHashMap<String, Map<Integer, PreviousPrice>>();
    private Map<String, Map<Integer, JsonNode>> lastSNPacket = new ConcurrentHashMap<String, Map<Integer, JsonNode>>();
    private Map<String, WriteQueueItem> writeQueue = new ConcurrentHashMap<String, WriteQueueItem>();
    private Timer recordInterval;
    private Timer deleteOldLogsInterval;
    private String root;

    public PacketLogger(LoggerOptions opts) throws IOException, ValidationException {
        OptionsValidator validator = new OptionsValidator();
        validator.validateNonZeroInt(opts.fileNumberLimit, "packetLogger.fileNumberLimit");
        validator.validateNonZeroInt(opts.logFileSizeInHours, "packetLogger.logFileSizeInHours");
        this.fileNumberLimit = opts.fileNumberLimit;
        this.logFileSizeInHours = opts.logFileSizeInHours;
        this.compressSpecifications = opts.compressSpecifications;
        this.compressPrices = opts.compressPrices;
        this.root = "./.metaapi/logs";
        Files.createDirectories(FileSystems.getDefault().getPath(this.root, new String[0]), new FileAttribute[0]);
    }

    public void logPacket(final JsonNode packet) {
        Integer packetSequenceNumber;
        int instanceIndex = packet.has("instanceIndex") ? packet.get("instanceIndex").asInt() : 0;
        String packetAccountId = packet.get("accountId").asText();
        String packetType = packet.get("type").asText();
        Integer n = packetSequenceNumber = packet.has("sequenceNumber") ? Integer.valueOf(packet.get("sequenceNumber").asInt()) : null;
        if (!this.writeQueue.containsKey(packetAccountId)) {
            this.writeQueue.put(packetAccountId, new WriteQueueItem(){
                {
                    this.isWriting = false;
                    this.queue = new ArrayList();
                }
            });
        }
        if (packetType.equals("status")) {
            return;
        }
        if (!this.lastSNPacket.containsKey(packetAccountId)) {
            this.lastSNPacket.put(packetAccountId, new ConcurrentHashMap());
        }
        if (packetType.equals("keepalive") || packetType.equals("noop")) {
            this.lastSNPacket.get(packetAccountId).put(instanceIndex, packet);
            return;
        }
        List<String> queue = this.writeQueue.get((Object)packetAccountId).queue;
        if (!this.previousPrices.containsKey(packetAccountId)) {
            this.previousPrices.put(packetAccountId, new ConcurrentHashMap());
        }
        PreviousPrice prevPrice = this.previousPrices.get(packetAccountId).get(instanceIndex);
        if (!packetType.equals("prices")) {
            if (prevPrice != null) {
                this.recordPrices(packetAccountId, instanceIndex);
            }
            if (packetType.equals("specifications") && this.compressSpecifications) {
                ObjectNode queueItem = JsonMapper.getInstance().createObjectNode();
                queueItem.put("type", packetType);
                queueItem.put("sequenceNumber", packetSequenceNumber);
                queueItem.set("sequenceTimestamp", packet.get("sequenceTimestamp"));
                queueItem.put("instanceIndex", instanceIndex);
                queue.add(queueItem.toString());
            } else {
                queue.add(packet.toString());
            }
        } else if (!this.compressPrices) {
            queue.add(packet.toString());
        } else if (prevPrice != null) {
            JsonNode lastKeepAlivePacket;
            ArrayList<Integer> validSequenceNumbers = new ArrayList<Integer>();
            validSequenceNumbers.add(prevPrice.last.has("sequenceNumber") ? Integer.valueOf(prevPrice.last.get("sequenceNumber").asInt()) : null);
            if (validSequenceNumbers.get(0) != null) {
                validSequenceNumbers.add((Integer)validSequenceNumbers.get(0) + 1);
            }
            if (this.lastSNPacket.get(packetAccountId).containsKey(instanceIndex) && (lastKeepAlivePacket = this.lastSNPacket.get(packetAccountId).get(instanceIndex)).has("sequenceNumber")) {
                validSequenceNumbers.add(lastKeepAlivePacket.get("sequenceNumber").asInt() + 1);
            }
            if (validSequenceNumbers.indexOf(packetSequenceNumber) == -1) {
                this.recordPrices(packetAccountId, instanceIndex);
                this.ensurePreviousPriceObject(packetAccountId);
                this.previousPrices.get(packetAccountId).put(instanceIndex, new PreviousPrice(){
                    {
                        this.first = packet;
                        this.last = packet;
                    }
                });
                queue.add(packet.toString());
            } else {
                prevPrice.last = packet;
            }
        } else {
            this.ensurePreviousPriceObject(packetAccountId);
            this.previousPrices.get(packetAccountId).put(instanceIndex, new PreviousPrice(){
                {
                    this.first = packet;
                    this.last = packet;
                }
            });
            queue.add(packet.toString());
        }
    }

    public List<LogMessage> readLogs(String accountId) {
        return this.readLogs(accountId, null, null);
    }

    public List<LogMessage> readLogs(String accountId, Date dateAfter, Date dateBefore) {
        File rootFolder = new File(this.root);
        File[] folders = rootFolder.listFiles();
        ArrayList<LogMessage> packets = new ArrayList<LogMessage>();
        for (File folder : folders) {
            Path filePath = FileSystems.getDefault().getPath(this.root, folder.getName(), accountId + ".log");
            if (!Files.exists(filePath, new LinkOption[0])) continue;
            try {
                List<String> contents = Files.readAllLines(filePath);
                ArrayList<LogMessage> messages = new ArrayList<LogMessage>();
                contents.removeIf(line -> line.length() == 0);
                for (final String line2 : contents) {
                    messages.add(new LogMessage(){
                        {
                            this.date = longDateFormat.parse(line2.substring(1, 24));
                            this.message = line2.substring(26);
                        }
                    });
                }
                if (dateAfter != null) {
                    messages.removeIf(message -> message.date.compareTo(dateAfter) != 1);
                }
                if (dateBefore != null) {
                    messages.removeIf(message -> message.date.compareTo(dateBefore) != -1);
                }
                packets.addAll(messages);
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        }
        return packets;
    }

    public String getFilePath(String accountId) throws IOException {
        Date now = Date.from(ServiceProvider.getNow());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        int fileIndex = calendar.get(11) / this.logFileSizeInHours;
        String folderName = shortDateFormat.format(now) + "-" + (fileIndex > 9 ? Integer.valueOf(fileIndex) : "0" + fileIndex);
        Files.createDirectories(FileSystems.getDefault().getPath(this.root, folderName), new FileAttribute[0]);
        return this.root + "/" + folderName + "/" + accountId + ".log";
    }

    public void start() {
        this.previousPrices.clear();
        if (this.recordInterval == null) {
            final PacketLogger self = this;
            this.recordInterval = new Timer();
            this.recordInterval.schedule(new TimerTask(){

                @Override
                public void run() {
                    self.appendLogs();
                }
            }, 1000L, 1000L);
            this.deleteOldLogsInterval = new Timer();
            this.deleteOldLogsInterval.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        self.deleteOldData();
                    }
                    catch (IOException e) {
                        logger.error("Failed to delete old data", (Throwable)e);
                    }
                }
            }, 10000L, 10000L);
        }
    }

    public void stop() {
        if (this.recordInterval != null) {
            this.recordInterval.cancel();
            this.recordInterval = null;
            this.deleteOldLogsInterval.cancel();
            this.deleteOldLogsInterval = null;
        }
    }

    private void recordPrices(String accountId, int instanceNumber) {
        int lastSequenceNumber;
        int firstSequenceNumber;
        PreviousPrice prevPrice = this.previousPrices.get(accountId).get(instanceNumber);
        if (prevPrice == null) {
            prevPrice = new PreviousPrice(){
                {
                    this.first = JsonMapper.getInstance().createObjectNode();
                    this.last = JsonMapper.getInstance().createObjectNode();
                }
            };
        }
        List<String> queue = this.writeQueue.get((Object)accountId).queue;
        this.previousPrices.get(accountId).remove(instanceNumber);
        if (this.previousPrices.get(accountId).size() == 0) {
            this.previousPrices.remove(accountId);
        }
        if ((firstSequenceNumber = prevPrice.first.get("sequenceNumber").asInt()) != (lastSequenceNumber = prevPrice.last.get("sequenceNumber").asInt())) {
            queue.add(prevPrice.last.toString());
            queue.add("Recorded price packets " + firstSequenceNumber + "-" + lastSequenceNumber + ", instanceIndex: " + instanceNumber);
        }
    }

    private void appendLogs() {
        this.writeQueue.keySet().forEach(key -> {
            WriteQueueItem queue = this.writeQueue.get(key);
            if (!queue.isWriting && queue.queue.size() != 0) {
                queue.isWriting = true;
                try {
                    String filePath = this.getFilePath((String)key);
                    String writeString = "";
                    for (String line : queue.queue) {
                        writeString = writeString + "[" + longDateFormat.format(Date.from(ServiceProvider.getNow())) + "] " + line + "\r\n";
                    }
                    queue.queue.clear();
                    FileUtils.writeByteArrayToFile((File)new File(filePath), (byte[])writeString.getBytes(StandardCharsets.UTF_8), (boolean)true);
                }
                catch (Throwable e) {
                    logger.info("Error writing log", e);
                }
                queue.isWriting = false;
            }
        });
    }

    private void deleteOldData() throws IOException {
        File rootFolder = new File(this.root);
        List<String> contents = Arrays.asList(rootFolder.list());
        Collections.sort(contents, Collator.getInstance());
        if (contents.size() > this.fileNumberLimit) {
            for (String folder : contents.subList(0, contents.size() - this.fileNumberLimit)) {
                FileUtils.deleteDirectory((File)new File(rootFolder + "/" + folder));
            }
        }
    }

    private void ensurePreviousPriceObject(String accountId) {
        if (!this.previousPrices.containsKey(accountId)) {
            this.previousPrices.put(accountId, new ConcurrentHashMap());
        }
    }

    private static class WriteQueueItem {
        public boolean isWriting;
        public List<String> queue;

        private WriteQueueItem() {
        }
    }

    private static class PreviousPrice {
        JsonNode first;
        JsonNode last;

        private PreviousPrice() {
        }
    }

    public static class LogMessage {
        public Date date;
        public String message;
    }

    public static class LoggerOptions {
        public boolean enabled = false;
        int fileNumberLimit = 12;
        int logFileSizeInHours = 4;
        boolean compressSpecifications = true;
        boolean compressPrices = true;
    }
}

