/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.error_handler.TooManyRequestsException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.Js;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubscriptionManager {
    private static Logger logger = LogManager.getLogger(SubscriptionManager.class);
    private MetaApiWebsocketClient websocketClient;
    private Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
    private Set<String> awaitingResubscribe = new HashSet<String>();

    public SubscriptionManager(MetaApiWebsocketClient websocketClient) {
        this.websocketClient = websocketClient;
    }

    public boolean isAccountSubscribing(String accountId, Integer instanceNumber) {
        if (instanceNumber != null) {
            return this.subscriptions.keySet().stream().filter(value -> value.equals(accountId + ":" + instanceNumber)).findFirst().isPresent();
        }
        for (String key : this.subscriptions.keySet()) {
            if (!key.startsWith(accountId)) continue;
            return true;
        }
        return false;
    }

    boolean isDisconnectedRetryMode(String accountId, Integer instanceNumber) {
        String instanceId = accountId + ":" + Js.or((Object[])new Integer[]{instanceNumber, 0});
        return this.subscriptions.containsKey(instanceId) ? this.subscriptions.get((Object)instanceId).isDisconnectedRetryMode : false;
    }

    public CompletableFuture<Void> subscribe(String accountId, Integer instanceNumber, boolean isDisconnectedRetryMode) {
        String instanceId = accountId + ":" + Js.or((Object[])new Integer[]{instanceNumber, 0});
        if (!this.subscriptions.containsKey(instanceId)) {
            Subscription newSubscription = new Subscription(){
                {
                    this.shouldRetry = true;
                    this.task = null;
                    this.waitTask = null;
                    this.future = null;
                }
            };
            newSubscription.isDisconnectedRetryMode = isDisconnectedRetryMode;
            this.subscriptions.put(instanceId, newSubscription);
            return Async.run(() -> {
                int subscribeRetryIntervalInSeconds = 3;
                while (this.subscriptions.get((Object)instanceId).shouldRetry) {
                    Timer waitTask;
                    final CompletableFuture<Boolean> resolveSubscribe = new CompletableFuture<Boolean>();
                    this.subscriptions.get((Object)instanceId).task = new Task(){
                        {
                            this.future = resolveSubscribe;
                        }
                    };
                    this.subscribeTask(accountId, instanceNumber, subscribeRetryIntervalInSeconds, resolveSubscribe);
                    this.subscriptions.get((Object)instanceId).task.future.join();
                    if (!this.subscriptions.get((Object)instanceId).shouldRetry) break;
                    int retryInterval = subscribeRetryIntervalInSeconds;
                    subscribeRetryIntervalInSeconds = Math.min(subscribeRetryIntervalInSeconds * 2, 300);
                    CompletableFuture subscribeFuture = new CompletableFuture();
                    this.subscriptions.get((Object)instanceId).waitTask = waitTask = Js.setTimeout(() -> subscribeFuture.complete(true), (int)(retryInterval * 1000));
                    this.subscriptions.get((Object)instanceId).future = subscribeFuture;
                    boolean result = this.subscriptions.get((Object)instanceId).future.join();
                    this.subscriptions.get((Object)instanceId).future = null;
                    if (result) continue;
                    break;
                }
                this.subscriptions.remove(instanceId);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> subscribeTask(String accountId, Integer instanceNumber, int subscribeRetryIntervalInSeconds, CompletableFuture<Boolean> subscribeFuture) {
        return Async.run(() -> {
            block6: {
                try {
                    this.websocketClient.subscribe(accountId, instanceNumber).join();
                }
                catch (CompletionException err) {
                    if (!(err.getCause() instanceof TooManyRequestsException)) break block6;
                    TooManyRequestsException tooManyRequestsErr = (TooManyRequestsException)err.getCause();
                    int socketInstanceIndex = this.websocketClient.getSocketInstancesByAccounts().get(accountId);
                    if (tooManyRequestsErr.metadata.type.equals("LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_USER")) {
                        logger.info((Object)err);
                    }
                    if (Arrays.asList("LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_USER", "LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_SERVER", "LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_USER_PER_SERVER").indexOf(tooManyRequestsErr.metadata.type) != -1) {
                        this.websocketClient.getSocketInstancesByAccounts().remove(accountId);
                        this.websocketClient.lockSocketInstance(socketInstanceIndex, tooManyRequestsErr.metadata);
                    }
                    long retryTime = ((TooManyRequestsException)err.getCause()).metadata.recommendedRetryTime.getDate().getTime();
                    if (new IsoTime().getDate().getTime() + (long)(subscribeRetryIntervalInSeconds * 1000) >= retryTime) break block6;
                    try {
                        Thread.sleep(retryTime - new IsoTime().getDate().getTime() - (long)(subscribeRetryIntervalInSeconds * 1000));
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e);
                    }
                }
            }
            subscribeFuture.complete(null);
        });
    }

    public void cancelSubscribe(String instanceId) {
        if (this.subscriptions.containsKey(instanceId)) {
            Subscription subscription = this.subscriptions.get(instanceId);
            if (subscription.future != null) {
                subscription.future.complete(false);
                subscription.waitTask.cancel();
            }
            if (subscription.task != null) {
                subscription.task.future.complete(false);
            }
            subscription.shouldRetry = false;
        }
    }

    public void cancelAccount(String accountId) {
        for (String instanceId : this.subscriptions.keySet().stream().filter(key -> key.startsWith(accountId)).collect(Collectors.toList())) {
            this.cancelSubscribe(instanceId);
        }
    }

    public void onTimeout(String accountId, Integer instanceNumber) {
        if (this.websocketClient.getSocketInstancesByAccounts().containsKey(accountId) && this.websocketClient.isConnected(this.websocketClient.getSocketInstancesByAccounts().getOrDefault(accountId, null))) {
            this.subscribe(accountId, instanceNumber, true);
        }
    }

    public CompletableFuture<Void> onDisconnected(String accountId, int instanceNumber) {
        return Async.run(() -> {
            try {
                Thread.sleep((long)(Math.max(ServiceProvider.getRandom() * 5.0, 1.0) * 1000.0));
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
            if (this.websocketClient.getSocketInstancesByAccounts().containsKey(accountId)) {
                this.subscribe(accountId, instanceNumber, true);
            }
        });
    }

    public void onReconnected(int socketInstanceIndex, List<String> reconnectAccountIds) {
        try {
            Map<String, Integer> socketInstancesByAccounts = this.websocketClient.getSocketInstancesByAccounts();
            for (String instanceId : new ArrayList<String>(this.subscriptions.keySet())) {
                String accountId2 = instanceId.split(":")[0];
                if (socketInstancesByAccounts.getOrDefault(accountId2, -1) != socketInstanceIndex) continue;
                this.cancelSubscribe(instanceId);
            }
            reconnectAccountIds.forEach(accountId -> Async.run(() -> {
                try {
                    if (!this.awaitingResubscribe.contains(accountId)) {
                        this.awaitingResubscribe.add((String)accountId);
                        while (this.isAccountSubscribing((String)accountId, null)) {
                            Thread.sleep(1000L);
                        }
                        this.awaitingResubscribe.remove(accountId);
                        Thread.sleep((long)(ServiceProvider.getRandom() * 5000.0));
                        this.subscribe((String)accountId, null, false);
                    }
                }
                catch (Throwable err) {
                    logger.error("[" + new IsoTime() + "] Account " + accountId + " resubscribe task failed", err);
                }
            }));
        }
        catch (Throwable err) {
            logger.error("[" + new IsoTime() + "] Failed to process subscribe manager reconnected event", err);
        }
    }

    private static class Task {
        public CompletableFuture<Boolean> future;

        private Task() {
        }
    }

    private static class Subscription {
        public boolean shouldRetry;
        public Task task;
        public Timer waitTask;
        public CompletableFuture<Boolean> future;
        public boolean isDisconnectedRetryMode;

        private Subscription() {
        }
    }
}

