/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MetaApiConnection;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionRegistry {
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private Map<String, MetaApiConnection> connections;
    private Map<String, CompletableFuture<Void>> connectionLocks;
    private String application;

    public ConnectionRegistry(MetaApiWebsocketClient metaApiWebsocketClient) {
        this(metaApiWebsocketClient, null);
    }

    public ConnectionRegistry(MetaApiWebsocketClient metaApiWebsocketClient, String application) {
        this.metaApiWebsocketClient = metaApiWebsocketClient;
        this.application = application != null ? application : "MetaApi";
        this.connections = new ConcurrentHashMap<String, MetaApiConnection>();
        this.connectionLocks = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    }

    public CompletableFuture<MetaApiConnection> connect(MetatraderAccount account, HistoryStorage historyStorage) {
        return this.connect(account, historyStorage, null);
    }

    public CompletableFuture<MetaApiConnection> connect(MetatraderAccount account, HistoryStorage historyStorage, IsoTime historyStartTime) {
        if (this.connections.containsKey(account.getId())) {
            return CompletableFuture.completedFuture(this.connections.get(account.getId()));
        }
        return Async.supply(() -> {
            while (this.connectionLocks.containsKey(account.getId())) {
                this.connectionLocks.get(account.getId()).join();
            }
            if (this.connections.containsKey(account.getId())) {
                return this.connections.get(account.getId());
            }
            CompletableFuture<Object> connectionLockResolve = new CompletableFuture<Object>();
            this.connectionLocks.put(account.getId(), connectionLockResolve);
            MetaApiConnection connection = ServiceProvider.createMetaApiConnection(this.metaApiWebsocketClient, account, historyStorage, this, historyStartTime);
            try {
                connection.initialize().join();
                connection.subscribe().join();
                this.connections.put(account.getId(), connection);
            }
            finally {
                this.connectionLocks.remove(account.getId());
                connectionLockResolve.complete(null);
            }
            return connection;
        });
    }

    public void remove(String accountId) {
        this.connections.remove(accountId);
    }

    public String getApplication() {
        return this.application;
    }
}

