/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.ExpertAdvisorClient;
import cloud.metaapi.sdk.util.Async;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class ExpertAdvisor {
    private ExpertAdvisorClient.ExpertAdvisorDto data;
    private String accountId;
    private ExpertAdvisorClient expertAdvisorClient;

    public ExpertAdvisor(ExpertAdvisorClient.ExpertAdvisorDto data, String accountId, ExpertAdvisorClient client) {
        this.data = data;
        this.accountId = accountId;
        this.expertAdvisorClient = client;
    }

    public String getExpertId() {
        return this.data.expertId;
    }

    public String getPeriod() {
        return this.data.period;
    }

    public String getSymbol() {
        return this.data.symbol;
    }

    public boolean isFileUploaded() {
        return this.data.fileUploaded;
    }

    public CompletableFuture<Void> reload() {
        return this.expertAdvisorClient.getExpertAdvisor(this.accountId, this.getExpertId()).thenAccept(dto -> {
            this.data = dto;
        });
    }

    public CompletableFuture<Void> update(ExpertAdvisorClient.NewExpertAdvisorDto expert) {
        return Async.run(() -> {
            this.expertAdvisorClient.updateExpertAdvisor(this.accountId, this.getExpertId(), expert).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> uploadFile(String filePath) {
        return Async.run(() -> {
            this.expertAdvisorClient.uploadExpertAdvisorFile(this.accountId, this.getExpertId(), filePath).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> uploadFile(InputStream fileContents) {
        return Async.run(() -> {
            this.expertAdvisorClient.uploadExpertAdvisorFile(this.accountId, this.getExpertId(), fileContents).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> remove() {
        return this.expertAdvisorClient.deleteExpertAdvisor(this.accountId, this.getExpertId());
    }
}

