/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoryFileManager {
    private static ObjectMapper jsonMapper = JsonMapper.getInstance();
    private static Logger logger = LogManager.getLogger(HistoryFileManager.class);
    private String accountId;
    private String application;
    private HistoryStorage historyStorage;
    private List<Integer> dealsSize = new ArrayList<Integer>();
    private int startNewDealIndex = -1;
    private List<Integer> historyOrdersSize = new ArrayList<Integer>();
    private int startNewOrderIndex = -1;
    private Timer updateDiskStorageJob = null;
    private boolean isUpdating = false;
    protected int updateJobIntervalInMilliseconds = 60000;

    public HistoryFileManager(String accountId, String application, HistoryStorage historyStorage) {
        this.accountId = accountId;
        this.application = application;
        this.historyStorage = historyStorage;
    }

    public void startUpdateJob() {
        if (this.updateDiskStorageJob == null) {
            final HistoryFileManager self = this;
            this.updateDiskStorageJob = new Timer();
            this.updateDiskStorageJob.schedule(new TimerTask(){

                @Override
                public void run() {
                    self.updateDiskStorage().exceptionally(e -> {
                        logger.error("Failed update disk storage of account " + HistoryFileManager.this.accountId, e);
                        return null;
                    });
                }
            }, this.updateJobIntervalInMilliseconds, (long)this.updateJobIntervalInMilliseconds);
        }
    }

    public void stopUpdateJob() {
        if (this.updateDiskStorageJob != null) {
            this.updateDiskStorageJob.cancel();
            this.updateDiskStorageJob = null;
        }
    }

    public int getItemSize(Object item) throws JsonProcessingException {
        return jsonMapper.writeValueAsBytes(item).length;
    }

    public void setStartNewOrderIndex(int index) {
        if (this.startNewOrderIndex > index || this.startNewOrderIndex == -1) {
            this.startNewOrderIndex = index;
        }
    }

    public void setStartNewDealIndex(int index) {
        if (this.startNewDealIndex > index || this.startNewDealIndex == -1) {
            this.startNewDealIndex = index;
        }
    }

    public CompletableFuture<History> getHistoryFromDisk() {
        return Async.supply(() -> {
            try {
                History history = new History();
                Path configPath = this.getFilePath("config");
                if (Files.exists(configPath, new LinkOption[0])) {
                    try {
                        String configContent = new String(Files.readAllBytes(configPath), StandardCharsets.UTF_8);
                        JsonNode config = jsonMapper.readTree(configContent);
                        if (config.has("lastDealTimeByInstanceIndex")) {
                            history.lastDealTimeByInstanceIndex = (Map)jsonMapper.readValue(config.get("lastDealTimeByInstanceIndex").toString(), (JavaType)jsonMapper.getTypeFactory().constructMapType(Map.class, Integer.class, Long.class));
                        }
                        if (config.has("lastHistoryOrderTimeByInstanceIndex")) {
                            history.lastHistoryOrderTimeByInstanceIndex = (Map)jsonMapper.readValue(config.get("lastHistoryOrderTimeByInstanceIndex").toString(), (JavaType)jsonMapper.getTypeFactory().constructMapType(Map.class, Integer.class, Long.class));
                        }
                    }
                    catch (Exception e) {
                        logger.error("Failed to read history storage config of account " + this.accountId, (Throwable)e);
                        Files.delete(configPath);
                    }
                }
                Pair<List<MetatraderDeal>, List<Integer>> dealsAndSizes = this.readHistoryItemsAndSizes(MetatraderDeal.class, "deals");
                history.deals = (List)dealsAndSizes.getLeft();
                this.dealsSize = (List)dealsAndSizes.getRight();
                Pair<List<MetatraderOrder>, List<Integer>> historyOrdersAndSizes = this.readHistoryItemsAndSizes(MetatraderOrder.class, "historyOrders");
                history.historyOrders = (List)historyOrdersAndSizes.getLeft();
                this.historyOrdersSize = (List)historyOrdersAndSizes.getRight();
                return history;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> updateDiskStorage() {
        return Async.run(() -> {
            if (!this.isUpdating) {
                this.isUpdating = true;
                try {
                    this.updateConfig().join();
                    Files.createDirectories(FileSystems.getDefault().getPath(".", ".metaapi"), new FileAttribute[0]);
                    this.dealsSize = this.updateDiskStorageWith("deals", this.startNewDealIndex, this.historyStorage.getDeals(), this.dealsSize);
                    this.startNewDealIndex = -1;
                    this.historyOrdersSize = this.updateDiskStorageWith("historyOrders", this.startNewOrderIndex, this.historyStorage.getHistoryOrders(), this.historyOrdersSize);
                    this.startNewOrderIndex = -1;
                }
                catch (IOException e) {
                    logger.error("Error updating disk storage for account " + this.accountId, (Throwable)e);
                }
                this.isUpdating = false;
            }
        });
    }

    private CompletableFuture<Void> updateConfig() {
        return Async.run(() -> {
            Path filePath = this.getFilePath("config");
            try {
                ObjectNode config = jsonMapper.createObjectNode();
                config.set("lastDealTimeByInstanceIndex", jsonMapper.valueToTree(this.historyStorage.getLastDealTimeByInstanceIndex()));
                config.set("lastHistoryOrderTimeByInstanceIndex", jsonMapper.valueToTree(this.historyStorage.getLastHistoryOrderTimeByInstanceIndex()));
                Files.write(filePath, config.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception err) {
                logger.error("Error updating disk storage config for account " + this.accountId, (Throwable)err);
            }
        });
    }

    public CompletableFuture<Void> deleteStorageFromDisk() {
        return Async.run(() -> {
            try {
                Files.delete(this.getFilePath("config"));
                Files.delete(this.getFilePath("deals"));
                Files.delete(this.getFilePath("historyOrders"));
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    private <T> Pair<List<T>, List<Integer>> readHistoryItemsAndSizes(Class<T> itemType, String type) throws IOException {
        Path path = this.getFilePath(type);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String fileContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                List items = (List)jsonMapper.readValue(fileContent, (JavaType)jsonMapper.getTypeFactory().constructCollectionType(List.class, itemType));
                List<Integer> sizes = this.readItemSizes(items, type);
                return Pair.of((Object)items, sizes);
            }
            catch (IOException e) {
                logger.error("Failed to read " + type + " history storage of account " + this.accountId, (Throwable)e);
                Files.delete(path);
            }
        }
        ArrayList emptyTypedList = new ArrayList();
        ArrayList emptyIntegerList = new ArrayList();
        return Pair.of(emptyTypedList, emptyIntegerList);
    }

    private <T> List<Integer> updateDiskStorageWith(String type, int startNewItemIndex, List<T> items, List<Integer> itemSizes) throws IOException {
        if (startNewItemIndex != -1) {
            Path filePath = this.getFilePath(type);
            if (!Files.exists(filePath, new LinkOption[0])) {
                try {
                    Files.write(filePath, jsonMapper.writeValueAsBytes(items), new OpenOption[0]);
                }
                catch (IOException e) {
                    logger.error("Error saving " + items + " on disk for account " + this.accountId, (Throwable)e);
                }
                return this.readItemSizes(items, type);
            }
            List<T> replaceItems = items.subList(startNewItemIndex, items.size());
            return this.replaceRecords(type, startNewItemIndex, replaceItems, itemSizes);
        }
        return itemSizes;
    }

    private <T> List<Integer> replaceRecords(String type, int startIndex, List<T> replaceItems, List<Integer> sizeArray) throws IOException {
        Path filePath = this.getFilePath(type);
        long fileSize = Files.size(filePath);
        if (startIndex == 0) {
            Files.write(filePath, jsonMapper.writeValueAsBytes(replaceItems), new OpenOption[0]);
        } else {
            List<Integer> replacedItems = sizeArray.subList(startIndex, sizeArray.size());
            long startPosition = fileSize - (long)replacedItems.size() - (long)replacedItems.stream().reduce((a, b) -> a + b).orElse(0).intValue() - 1L;
            FileOutputStream fileStream = new FileOutputStream(filePath.toString(), true);
            FileChannel fileChannel = fileStream.getChannel();
            fileChannel.truncate(startPosition);
            fileChannel.write(Charset.forName("UTF-8").encode("," + jsonMapper.writeValueAsString(replaceItems).substring(1)), startPosition);
            fileStream.close();
        }
        return Stream.concat(sizeArray.subList(0, startIndex).stream(), this.readItemSizes(replaceItems, type).stream()).collect(Collectors.toList());
    }

    private <T> List<Integer> readItemSizes(List<T> items, String type) {
        return items.stream().map(item -> {
            try {
                return this.getItemSize(item);
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to read the " + type + " size of account " + this.accountId, (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    private Path getFilePath(String type) {
        return FileSystems.getDefault().getPath(".", ".metaapi", this.accountId + "-" + this.application + "-" + type + ".bin");
    }

    public static class History {
        public List<MetatraderDeal> deals = new ArrayList<MetatraderDeal>();
        public List<MetatraderOrder> historyOrders = new ArrayList<MetatraderOrder>();
        public Map<String, Long> lastDealTimeByInstanceIndex = new ConcurrentHashMap<String, Long>();
        public Map<String, Long> lastHistoryOrderTimeByInstanceIndex = new ConcurrentHashMap<String, Long>();
    }
}

