/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.LatencyListener;
import cloud.metaapi.sdk.meta_api.reservoir.Reservoir;
import cloud.metaapi.sdk.meta_api.reservoir.StatisticalReservoir;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LatencyMonitor
extends LatencyListener {
    private static Logger logger = LogManager.getLogger(LatencyMonitor.class);
    private MapReservoirs<MapReservoirs<MonitorReservoir>> tradeReservoirs;
    private MapReservoirs<MapReservoirs<MonitorReservoir>> updateReservoirs;
    private MapReservoirs<MapReservoirs<MonitorReservoir>> priceReservoirs;
    private MapReservoirs<MapReservoirs<MapReservoirs<MonitorReservoir>>> requestReservoirs;

    public LatencyMonitor() {
        ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>> tradeReservoirMap = new ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>>();
        tradeReservoirMap.put("clientLatency", this.initializeReservoirs());
        tradeReservoirMap.put("serverLatency", this.initializeReservoirs());
        tradeReservoirMap.put("brokerLatency", this.initializeReservoirs());
        this.tradeReservoirs = new MapReservoirs(tradeReservoirMap);
        ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>> updateReservoirMap = new ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>>();
        updateReservoirMap.put("clientLatency", this.initializeReservoirs());
        updateReservoirMap.put("serverLatency", this.initializeReservoirs());
        updateReservoirMap.put("brokerLatency", this.initializeReservoirs());
        this.updateReservoirs = new MapReservoirs(updateReservoirMap);
        ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>> priceReservoirMap = new ConcurrentHashMap<String, MapReservoirs<MonitorReservoir>>();
        priceReservoirMap.put("clientLatency", this.initializeReservoirs());
        priceReservoirMap.put("serverLatency", this.initializeReservoirs());
        priceReservoirMap.put("brokerLatency", this.initializeReservoirs());
        this.priceReservoirs = new MapReservoirs(priceReservoirMap);
        this.requestReservoirs = new MapReservoirs(null);
    }

    @Override
    public CompletableFuture<Void> onResponse(String accountId, String type, LatencyListener.ResponseTimestamps timestamps) {
        if (this.requestReservoirs.get(type) == null) {
            MapReservoirs<MapReservoirs<MonitorReservoir>> reservoirsByLatencyType = new MapReservoirs<MapReservoirs<MonitorReservoir>>(null);
            reservoirsByLatencyType.set("clientLatency", this.initializeReservoirs());
            reservoirsByLatencyType.set("serverLatency", this.initializeReservoirs());
            this.requestReservoirs.set(type, reservoirsByLatencyType);
        }
        if (timestamps.serverProcessingStarted != null && timestamps.serverProcessingFinished != null) {
            long serverLatency = timestamps.serverProcessingFinished.getDate().getTime() - timestamps.serverProcessingStarted.getDate().getTime();
            this.saveMeasurement(this.requestReservoirs.get(type).get("serverLatency"), serverLatency);
        }
        if (timestamps.clientProcessingStarted != null && timestamps.clientProcessingFinished != null && timestamps.serverProcessingStarted != null && timestamps.serverProcessingFinished != null) {
            long serverLatency = timestamps.serverProcessingFinished.getDate().getTime() - timestamps.serverProcessingStarted.getDate().getTime();
            long clientLatency = timestamps.clientProcessingFinished.getDate().getTime() - timestamps.clientProcessingStarted.getDate().getTime() - serverLatency;
            this.saveMeasurement(this.requestReservoirs.get(type).get("clientLatency"), clientLatency);
        }
        return CompletableFuture.completedFuture(null);
    }

    public Map<String, MonitorLatencies> getRequestLatencies() {
        ConcurrentHashMap<String, MonitorLatencies> result = new ConcurrentHashMap<String, MonitorLatencies>();
        Map<String, Object> latencyMap = this.constructLatenciesRecursively(this.requestReservoirs);
        for (Map.Entry<String, Object> entry : latencyMap.entrySet()) {
            result.put(entry.getKey(), this.constructMonitorLatencies((Map)entry.getValue()));
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> onSymbolPrice(String accountId, String symbol, LatencyListener.SymbolPriceTimestamps timestamps) {
        if (timestamps.eventGenerated != null && timestamps.serverProcessingStarted != null) {
            long brokerLatency = timestamps.serverProcessingStarted.getDate().getTime() - timestamps.eventGenerated.getDate().getTime();
            this.saveMeasurement(this.priceReservoirs.get("brokerLatency"), brokerLatency);
        }
        if (timestamps.serverProcessingStarted != null && timestamps.serverProcessingFinished != null) {
            long serverLatency = timestamps.serverProcessingFinished.getDate().getTime() - timestamps.serverProcessingStarted.getDate().getTime();
            this.saveMeasurement(this.priceReservoirs.get("serverLatency"), serverLatency);
        }
        if (timestamps.serverProcessingFinished != null && timestamps.clientProcessingFinished != null) {
            long clientLatency = timestamps.clientProcessingFinished.getDate().getTime() - timestamps.serverProcessingFinished.getDate().getTime();
            this.saveMeasurement(this.priceReservoirs.get("clientLatency"), clientLatency);
        }
        return CompletableFuture.completedFuture(null);
    }

    public MonitorLatencies getPriceLatencies() {
        return this.constructMonitorLatencies(this.constructLatenciesRecursively(this.priceReservoirs));
    }

    @Override
    public CompletableFuture<Void> onUpdate(String accountId, LatencyListener.UpdateTimestamps timestamps) {
        if (timestamps.eventGenerated != null && timestamps.serverProcessingStarted != null) {
            long brokerLatency = timestamps.serverProcessingStarted.getDate().getTime() - timestamps.eventGenerated.getDate().getTime();
            this.saveMeasurement(this.updateReservoirs.get("brokerLatency"), brokerLatency);
        }
        if (timestamps.serverProcessingStarted != null && timestamps.serverProcessingFinished != null) {
            long serverLatency = timestamps.serverProcessingFinished.getDate().getTime() - timestamps.serverProcessingStarted.getDate().getTime();
            this.saveMeasurement(this.updateReservoirs.get("serverLatency"), serverLatency);
        }
        if (timestamps.serverProcessingFinished != null && timestamps.clientProcessingFinished != null) {
            long clientLatency = timestamps.clientProcessingFinished.getDate().getTime() - timestamps.serverProcessingFinished.getDate().getTime();
            this.saveMeasurement(this.updateReservoirs.get("clientLatency"), clientLatency);
        }
        return CompletableFuture.completedFuture(null);
    }

    public MonitorLatencies getUpdateLatencies() {
        return this.constructMonitorLatencies(this.constructLatenciesRecursively(this.updateReservoirs));
    }

    @Override
    public CompletableFuture<Void> onTrade(String accountId, LatencyListener.TradeTimestamps timestamps) {
        if (timestamps.clientProcessingStarted != null && timestamps.serverProcessingStarted != null) {
            long clientLatency = timestamps.serverProcessingStarted.getDate().getTime() - timestamps.clientProcessingStarted.getDate().getTime();
            this.saveMeasurement(this.tradeReservoirs.get("clientLatency"), clientLatency);
        }
        if (timestamps.serverProcessingStarted != null && timestamps.tradeStarted != null) {
            long serverLatency = timestamps.tradeStarted.getDate().getTime() - timestamps.serverProcessingStarted.getDate().getTime();
            this.saveMeasurement(this.tradeReservoirs.get("serverLatency"), serverLatency);
        }
        if (timestamps.tradeStarted != null && timestamps.tradeExecuted != null) {
            long brokerLatency = timestamps.tradeExecuted.getDate().getTime() - timestamps.tradeStarted.getDate().getTime();
            this.saveMeasurement(this.tradeReservoirs.get("brokerLatency"), brokerLatency);
        }
        return CompletableFuture.completedFuture(null);
    }

    public MonitorLatencies getTradeLatencies() {
        return this.constructMonitorLatencies(this.constructLatenciesRecursively(this.tradeReservoirs));
    }

    private void saveMeasurement(MapReservoirs<MonitorReservoir> reservoirs, long clientLatency) {
        reservoirs.getReservoirs().forEach(reservoir -> {
            reservoir.percentiles.pushMeasurement(clientLatency);
            reservoir.reservoir.pushMeasurement(clientLatency);
        });
    }

    private Map<String, Object> constructLatenciesRecursively(MapReservoirs<?> reservoirs) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, ?> entry : reservoirs.getEntries()) {
            if (entry.getValue() instanceof MapReservoirs) {
                result.put(entry.getKey(), this.constructLatenciesRecursively((MapReservoirs)entry.getValue()));
                continue;
            }
            final MonitorReservoir reservoir = (MonitorReservoir)entry.getValue();
            result.put(entry.getKey(), new Latencies(){
                {
                    this.p50 = reservoir.percentiles.getPercentile(50.0);
                    this.p75 = reservoir.percentiles.getPercentile(75.0);
                    this.p90 = reservoir.percentiles.getPercentile(90.0);
                    this.p95 = reservoir.percentiles.getPercentile(95.0);
                    this.p98 = reservoir.percentiles.getPercentile(98.0);
                    this.avg = reservoir.reservoir.getStatistics().average;
                    this.count = reservoir.reservoir.getStatistics().count;
                    this.min = reservoir.reservoir.getStatistics().min.longValue();
                    this.max = reservoir.reservoir.getStatistics().max.longValue();
                }
            });
        }
        return result;
    }

    private MonitorLatencies constructMonitorLatencies(Map<String, Object> latencyMap) {
        MonitorLatencies result = new MonitorLatencies();
        for (Map.Entry<String, Object> entry : latencyMap.entrySet()) {
            try {
                FieldUtils.writeField((Object)result, (String)entry.getKey(), (Object)entry.getValue());
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    private MapReservoirs<MonitorReservoir> initializeReservoirs() {
        ConcurrentHashMap<String, MonitorReservoir> reservoirs = new ConcurrentHashMap<String, MonitorReservoir>();
        reservoirs.put("1h", new MonitorReservoir(){
            {
                this.percentiles = new StatisticalReservoir(1000, 3600000L);
                this.reservoir = new Reservoir(60, 3600000);
            }
        });
        reservoirs.put("1d", new MonitorReservoir(){
            {
                this.percentiles = new StatisticalReservoir(1000, 3600000L);
                this.reservoir = new Reservoir(60, 3600000);
            }
        });
        reservoirs.put("1w", new MonitorReservoir(){
            {
                this.percentiles = new StatisticalReservoir(1000, 3600000L);
                this.reservoir = new Reservoir(60, 3600000);
            }
        });
        return new MapReservoirs<MonitorReservoir>(reservoirs);
    }

    private static class MapReservoirs<T> {
        private Map<String, T> reservoirs;

        public MapReservoirs(Map<String, T> reservoirs) {
            this.reservoirs = reservoirs != null ? reservoirs : new ConcurrentHashMap();
        }

        public void set(String key, T reservoir) {
            this.reservoirs.put(key, reservoir);
        }

        public T get(String type) {
            return this.reservoirs.get(type);
        }

        public Collection<T> getReservoirs() {
            return this.reservoirs.values();
        }

        public Set<Map.Entry<String, T>> getEntries() {
            return this.reservoirs.entrySet();
        }
    }

    private static class MonitorReservoir {
        public StatisticalReservoir percentiles;
        public Reservoir reservoir;

        private MonitorReservoir() {
        }
    }

    public static class Latencies {
        public double p50;
        public double p75;
        public double p90;
        public double p95;
        public double p98;
        public double avg;
        public int count;
        public double min;
        public double max;
    }

    public static class MonitorLatencies {
        public Map<String, Latencies> clientLatency;
        public Map<String, Latencies> serverLatency;
        public Map<String, Latencies> brokerLatency;
    }
}

