/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.ExpertAdvisorClient;
import cloud.metaapi.sdk.clients.meta_api.HistoricalMarketDataClient;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.models.AccountsFilter;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.NewMetatraderAccountDto;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

public class MetatraderAccountApi {
    private MetatraderAccountClient metatraderAccountClient;
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private ConnectionRegistry connectionRegistry;
    private HistoricalMarketDataClient historicalMarketDataClient;
    private ExpertAdvisorClient expertAdvisorClient;

    public MetatraderAccountApi(MetatraderAccountClient metatraderAccountClient, MetaApiWebsocketClient metaApiWebsocketClient, ConnectionRegistry connectionRegistry, ExpertAdvisorClient expertAdvisorClient, HistoricalMarketDataClient historicalMarketDataClient) {
        this.metatraderAccountClient = metatraderAccountClient;
        this.metaApiWebsocketClient = metaApiWebsocketClient;
        this.connectionRegistry = connectionRegistry;
        this.expertAdvisorClient = expertAdvisorClient;
        this.historicalMarketDataClient = historicalMarketDataClient;
    }

    public CompletableFuture<List<MetatraderAccount>> getAccounts() {
        return this.getAccounts(null);
    }

    public CompletableFuture<List<MetatraderAccount>> getAccounts(AccountsFilter accountsFilter) {
        return this.metatraderAccountClient.getAccounts(accountsFilter).thenApply(accounts -> accounts.stream().map(accountDto -> new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry, this.expertAdvisorClient, this.historicalMarketDataClient)).collect(Collectors.toList()));
    }

    public CompletableFuture<MetatraderAccount> getAccount(String accountId) {
        return this.metatraderAccountClient.getAccount(accountId).thenApply(accountDto -> new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry, this.expertAdvisorClient, this.historicalMarketDataClient));
    }

    public CompletableFuture<MetatraderAccount> getAccountByToken() {
        return this.metatraderAccountClient.getAccountByToken().thenApply(accountDto -> new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry, this.expertAdvisorClient, this.historicalMarketDataClient));
    }

    public CompletableFuture<MetatraderAccount> createAccount(NewMetatraderAccountDto account) {
        return this.metatraderAccountClient.createAccount(account).thenApply(id -> {
            try {
                return this.getAccount(id.id).get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }
}

