/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.Js;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class TerminalState
extends SynchronizationListener {
    protected int statusTimerTimeoutInMilliseconds = 60000;
    private Map<String, State> stateByInstanceIndex = new ConcurrentHashMap<String, State>();
    private Map<String, List<CompletableFuture<Void>>> waitForPriceResolves = new ConcurrentHashMap<String, List<CompletableFuture<Void>>>();

    public boolean isConnected() {
        return this.stateByInstanceIndex.values().stream().filter(state -> state.connected).findFirst().isPresent();
    }

    public boolean isConnectedToBroker() {
        return this.stateByInstanceIndex.values().stream().filter(state -> state.connectedToBroker).findFirst().isPresent();
    }

    public Optional<MetatraderAccountInformation> getAccountInformation() {
        return Optional.ofNullable(this.getBestState().accountInformation);
    }

    public List<MetatraderPosition> getPositions() {
        return this.getBestState().positions;
    }

    public List<MetatraderOrder> getOrders() {
        return this.getBestState().orders;
    }

    public List<MetatraderSymbolSpecification> getSpecifications() {
        return this.getBestState().specifications;
    }

    public Optional<MetatraderSymbolSpecification> getSpecification(String symbol) {
        return Optional.ofNullable(this.getBestState((String)symbol, (String)"specification").specificationsBySymbol.get(symbol));
    }

    public Optional<MetatraderSymbolPrice> getPrice(String symbol) {
        return Optional.ofNullable(this.getBestState((String)symbol, (String)"price").pricesBySymbol.get(symbol));
    }

    public CompletableFuture<Optional<MetatraderSymbolPrice>> waitForPrice(String symbol) {
        return this.waitForPrice(symbol, null);
    }

    public CompletableFuture<Optional<MetatraderSymbolPrice>> waitForPrice(String symbol, Long timeoutInSeconds) {
        if (timeoutInSeconds == null) {
            timeoutInSeconds = 30L;
        }
        long timeoutInSecondsFinal = timeoutInSeconds;
        return Async.supply(() -> {
            if (!this.getPrice(symbol).isPresent()) {
                if (!this.waitForPriceResolves.containsKey(symbol)) {
                    this.waitForPriceResolves.put(symbol, new ArrayList());
                }
                CompletableFuture waitFuture = new CompletableFuture();
                this.waitForPriceResolves.get(symbol).add(waitFuture);
                try {
                    waitFuture.get(timeoutInSecondsFinal, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (Throwable err) {
                    throw new CompletionException(err);
                }
            }
            return this.getPrice(symbol);
        });
    }

    @Override
    public CompletableFuture<Void> onConnected(String instanceIndex, int replicas) {
        this.getState((String)instanceIndex).connected = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDisconnected(String instanceIndex) {
        State state = this.getState(instanceIndex);
        state.connected = false;
        state.connectedToBroker = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onBrokerConnectionStatusChanged(String instanceIndex, boolean connected) {
        this.getState((String)instanceIndex).connectedToBroker = connected;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onSynchronizationStarted(String instanceIndex) {
        State state = this.getState(instanceIndex);
        state.accountInformation = null;
        state.positions.clear();
        state.orders.clear();
        state.specifications.clear();
        state.specificationsBySymbol.clear();
        state.pricesBySymbol.clear();
        state.completedOrders.clear();
        state.removedPositions.clear();
        state.positionsInitialized = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onAccountInformationUpdated(String instanceIndex, MetatraderAccountInformation accountInformation) {
        State state = this.getState(instanceIndex);
        state.accountInformation = accountInformation;
        state.initializationCounter = 1;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onPositionsReplaced(String instanceIndex, List<MetatraderPosition> positions) {
        State state = this.getState(instanceIndex);
        state.positions = new ArrayList<MetatraderPosition>(positions);
        state.removedPositions.clear();
        state.positionsInitialized = true;
        state.initializationCounter = 2;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onPositionUpdated(String instanceIndex, MetatraderPosition position) {
        State state = this.getState(instanceIndex);
        int index = -1;
        for (int i = 0; i < state.positions.size(); ++i) {
            if (!state.positions.get((int)i).id.equals(position.id)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            state.positions.set(index, position);
        } else if (!state.removedPositions.containsKey(position.id)) {
            state.positions.add(position);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onPositionRemoved(String instanceIndex, String positionId) {
        State state = this.getState(instanceIndex);
        Optional<MetatraderPosition> position = state.positions.stream().filter(p -> p.id.equals(positionId)).findFirst();
        if (!position.isPresent()) {
            for (Map.Entry<String, Date> e : state.removedPositions.entrySet()) {
                if (e.getValue().getTime() + 300000L >= Date.from(Instant.now()).getTime()) continue;
                state.removedPositions.remove(e.getKey());
            }
            state.removedPositions.put(positionId, Date.from(Instant.now()));
        } else {
            state.positions.removeIf(p -> p.id.equals(positionId));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrdersReplaced(String instanceIndex, List<MetatraderOrder> orders) {
        State state = this.getState(instanceIndex);
        state.orders = new ArrayList<MetatraderOrder>(orders);
        state.completedOrders.clear();
        state.ordersInitialized = true;
        state.initializationCounter = 3;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderUpdated(String instanceIndex, MetatraderOrder order) {
        State state = this.getState(instanceIndex);
        int index = -1;
        for (int i = 0; i < state.orders.size(); ++i) {
            if (!state.orders.get((int)i).id.equals(order.id)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            state.orders.set(index, order);
        } else if (!state.completedOrders.containsKey(order.id)) {
            state.orders.add(order);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderCompleted(String instanceIndex, String orderId) {
        State state = this.getState(instanceIndex);
        Optional<MetatraderOrder> order = state.orders.stream().filter(o -> !o.id.equals(orderId)).findFirst();
        if (!order.isPresent()) {
            for (Map.Entry<String, Date> e : state.completedOrders.entrySet()) {
                if (e.getValue().getTime() + 300000L >= Date.from(Instant.now()).getTime()) continue;
                state.completedOrders.remove(e.getKey());
            }
            state.completedOrders.put(orderId, Date.from(Instant.now()));
        } else {
            state.orders.removeIf(o -> o.id.equals(orderId));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onSymbolSpecificationsUpdated(String instanceIndex, List<MetatraderSymbolSpecification> specifications, List<String> removedSymbols) {
        State state = this.getState(instanceIndex);
        for (MetatraderSymbolSpecification specification : specifications) {
            int index = -1;
            for (int i = 0; i < state.specifications.size(); ++i) {
                if (!state.specifications.get((int)i).symbol.equals(specification.symbol)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                state.specifications.set(index, specification);
            } else {
                state.specifications.add(specification);
            }
            state.specificationsBySymbol.put(specification.symbol, specification);
        }
        state.specifications = state.specifications.stream().filter(s -> !removedSymbols.contains(s.symbol)).collect(Collectors.toList());
        for (String symbol : removedSymbols) {
            state.specificationsBySymbol.remove(symbol);
        }
        state.specificationCount = state.specifications.size();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onSymbolPricesUpdated(String instanceIndex, List<MetatraderSymbolPrice> prices, Double equity, Double margin, Double freeMargin, Double marginLevel, Double accountCurrencyExchangeRate) {
        State state = this.getState(instanceIndex);
        state.lastUpdateTime = 0L;
        for (MetatraderSymbolPrice metatraderSymbolPrice : prices) {
            if (metatraderSymbolPrice.time.getDate().getTime() <= state.lastUpdateTime) continue;
            state.lastUpdateTime = metatraderSymbolPrice.time.getDate().getTime();
        }
        boolean pricesInitialized = false;
        for (MetatraderSymbolPrice price : prices) {
            state.pricesBySymbol.put(price.symbol, price);
            List positions = state.positions.stream().filter(p -> p.symbol.equals(price.symbol)).collect(Collectors.toList());
            List otherPositions = state.positions.stream().filter(p -> !p.symbol.equals(price.symbol)).collect(Collectors.toList());
            List orders = state.orders.stream().filter(o -> o.symbol.equals(price.symbol)).collect(Collectors.toList());
            pricesInitialized = true;
            for (MetatraderPosition position : otherPositions) {
                MetatraderSymbolPrice p2 = state.pricesBySymbol.get(position.symbol);
                if (p2 != null) {
                    if (position.unrealizedProfit != null) continue;
                    this.updatePositionProfits(position, p2);
                    continue;
                }
                pricesInitialized = false;
            }
            for (MetatraderPosition position : positions) {
                this.updatePositionProfits(position, price);
            }
            for (MetatraderOrder order : orders) {
                order.currentPrice = order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY || order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_LIMIT || order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_STOP || order.type == MetatraderOrder.OrderType.ORDER_TYPE_BUY_STOP_LIMIT ? price.ask : price.bid;
            }
            List<CompletableFuture<Void>> priceResolves = this.waitForPriceResolves.get(price.symbol);
            if (priceResolves == null || priceResolves.size() <= 0) continue;
            for (CompletableFuture<Void> resolve : priceResolves) {
                resolve.complete(null);
            }
            this.waitForPriceResolves.remove(price.symbol);
        }
        if (state.accountInformation != null) {
            if (state.positionsInitialized && pricesInitialized) {
                String string = state.accountInformation.platform;
                state.accountInformation.equity = string != null && string.equals("mt5") ? (equity != null ? equity : state.accountInformation.balance + (Double)Js.reduce(state.positions, (acc, p) -> acc + (double)Math.round((Double)Js.or((Object[])new Double[]{p.unrealizedProfit, 0.0}) * 100.0) / 100.0 + (double)Math.round((Double)Js.or((Object[])new Double[]{p.swap, 0.0}) * 100.0) / 100.0, (Object)0.0)) : (equity != null ? equity : state.accountInformation.balance + (Double)Js.reduce(state.positions, (acc, p) -> acc + (double)(Math.round((Double)Js.or((Object[])new Double[]{p.swap, 0.0}) * 100.0) / 100L) + (double)(Math.round((Double)Js.or((Object[])new Double[]{p.commission, 0.0}) * 100.0) / 100L) + (double)(Math.round((Double)Js.or((Object[])new Double[]{p.unrealizedProfit, 0.0}) * 100.0) / 100L), (Object)0.0));
                state.accountInformation.equity = (double)Math.round(state.accountInformation.equity * 100.0) / 100.0;
            } else {
                state.accountInformation.equity = equity != null ? equity : state.accountInformation.equity;
            }
            state.accountInformation.margin = margin != null ? margin : state.accountInformation.margin;
            state.accountInformation.freeMargin = freeMargin != null ? freeMargin : state.accountInformation.freeMargin;
            state.accountInformation.marginLevel = freeMargin != null ? marginLevel : state.accountInformation.marginLevel;
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onStreamClosed(String instanceIndex) {
        this.stateByInstanceIndex.remove(instanceIndex);
        return CompletableFuture.completedFuture(null);
    }

    private void updatePositionProfits(MetatraderPosition position, MetatraderSymbolPrice price) {
        Optional<MetatraderSymbolSpecification> specification = this.getSpecification(position.symbol);
        if (specification.isPresent()) {
            double multiplier = Math.pow(10.0, specification.get().digits);
            if (position.profit != null) {
                position.profit = (double)Math.round(position.profit * multiplier) / multiplier;
            }
            if (position.unrealizedProfit == null || position.realizedProfit == null) {
                position.unrealizedProfit = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (position.currentPrice - position.openPrice) * position.currentTickValue * position.volume / specification.get().tickSize;
                position.unrealizedProfit = (double)Math.round(position.unrealizedProfit * multiplier) / multiplier;
                position.realizedProfit = position.profit - position.unrealizedProfit;
            }
            double newPositionPrice = position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? price.bid : price.ask;
            double isProfitable = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (newPositionPrice - position.openPrice);
            double currentTickValue = isProfitable > 0.0 ? price.profitTickValue : price.lossTickValue;
            double unrealizedProfit = (double)(position.type == MetatraderPosition.PositionType.POSITION_TYPE_BUY ? 1 : -1) * (newPositionPrice - position.openPrice) * currentTickValue * position.volume / specification.get().tickSize;
            unrealizedProfit = (double)Math.round(unrealizedProfit * multiplier) / multiplier;
            position.unrealizedProfit = unrealizedProfit;
            position.profit = position.unrealizedProfit + position.realizedProfit;
            position.profit = (double)Math.round(position.profit * multiplier) / multiplier;
            position.currentPrice = newPositionPrice;
            position.currentTickValue = currentTickValue;
        }
    }

    private State getState(String instanceIndex) {
        if (!this.stateByInstanceIndex.containsKey(instanceIndex)) {
            this.stateByInstanceIndex.put(instanceIndex, this.constructTerminalState(instanceIndex));
        }
        return this.stateByInstanceIndex.get(instanceIndex);
    }

    private State constructTerminalState(String instanceIndex) {
        State result = new State();
        result.instanceIndex = instanceIndex;
        return result;
    }

    private State getBestState() {
        return this.getBestState(null, "default");
    }

    private State getBestState(String symbol, String mode) {
        State result = null;
        Long maxUpdateTime = -1L;
        int maxInitializationCounter = -1;
        int maxSpecificationCount = -1;
        for (State state : this.stateByInstanceIndex.values()) {
            if (maxInitializationCounter >= state.initializationCounter && (maxInitializationCounter != state.initializationCounter || maxInitializationCounter != 3 || maxUpdateTime >= state.lastUpdateTime) && (maxInitializationCounter != state.initializationCounter || maxInitializationCounter != 0 || maxSpecificationCount >= state.specificationCount) || symbol != null && (!mode.equals("specification") || !state.specificationsBySymbol.containsKey(symbol)) && (!mode.equals("price") || !state.pricesBySymbol.containsKey(symbol))) continue;
            maxUpdateTime = state.lastUpdateTime;
            maxInitializationCounter = state.initializationCounter;
            maxSpecificationCount = state.specificationCount;
            result = state;
        }
        return result != null ? result : this.constructTerminalState(null);
    }

    private static class State {
        public String instanceIndex;
        public boolean connected = false;
        public boolean connectedToBroker = false;
        public MetatraderAccountInformation accountInformation = null;
        public List<MetatraderPosition> positions = new ArrayList<MetatraderPosition>();
        public List<MetatraderOrder> orders = new ArrayList<MetatraderOrder>();
        public List<MetatraderSymbolSpecification> specifications = new ArrayList<MetatraderSymbolSpecification>();
        public Map<String, MetatraderSymbolSpecification> specificationsBySymbol = new ConcurrentHashMap<String, MetatraderSymbolSpecification>();
        public Map<String, MetatraderSymbolPrice> pricesBySymbol = new ConcurrentHashMap<String, MetatraderSymbolPrice>();
        public Map<String, Date> completedOrders = new ConcurrentHashMap<String, Date>();
        public Map<String, Date> removedPositions = new ConcurrentHashMap<String, Date>();
        public boolean ordersInitialized = false;
        public boolean positionsInitialized = false;
        public long lastUpdateTime = 0L;
        public int initializationCounter = 0;
        public int specificationCount = 0;

        private State() {
        }
    }
}

