/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api.reservoir;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AvlTree<T> {
    public Node root = null;
    private Comparator<T> comparer;

    private Node createNewNode(final T k) {
        return new Node(){
            {
                this.key = k;
                this.weight = 1;
                this.height = 0;
                this.left = null;
                this.right = null;
            }
        };
    }

    private int height(Node p) {
        return p != null ? p.height : 0;
    }

    private int weight(Node p) {
        return p != null ? p.weight : 0;
    }

    private int bFactor(Node p) {
        return this.height(p.right) - this.height(p.left);
    }

    private void countHeightAndWeight(Node p) {
        int hr;
        int hl = this.height(p.left);
        p.height = (hl > (hr = this.height(p.right)) ? hl : hr) + 1;
        int wl = this.weight(p.left);
        int wr = this.weight(p.right);
        p.weight = wl + wr + 1;
    }

    private Node rotateRight(Node p) {
        Node q = p.left;
        p.left = q.right;
        q.right = p;
        this.countHeightAndWeight(p);
        this.countHeightAndWeight(q);
        return q;
    }

    private Node rotateLeft(Node q) {
        Node p = q.right;
        q.right = p.left;
        p.left = q;
        this.countHeightAndWeight(q);
        this.countHeightAndWeight(p);
        return p;
    }

    private Node balance(Node p) {
        this.countHeightAndWeight(p);
        if (this.bFactor(p) == 2) {
            if (this.bFactor(p.right) < 0) {
                p.right = this.rotateRight(p.right);
            }
            return this.rotateLeft(p);
        }
        if (this.bFactor(p) == -2) {
            if (this.bFactor(p.left) > 0) {
                p.left = this.rotateLeft(p.left);
            }
            return this.rotateRight(p);
        }
        return p;
    }

    private int count(Node p, T k) {
        return this.upperBound(p, k) - this.lowerBound(p, k);
    }

    private T at(Node p, int k) {
        if (p == null) {
            return null;
        }
        int wl = this.weight(p.left);
        if (wl <= k && k < wl + 1) {
            return p.key;
        }
        if (k < wl) {
            return this.at(p.left, k);
        }
        return this.at(p.right, k - wl - 1);
    }

    private Node getMinimum(Node p) {
        if (p == null) {
            return null;
        }
        return p.left != null ? this.getMinimum(p.left) : p;
    }

    private Node getMaximum(Node p) {
        if (p == null) {
            return null;
        }
        return p.right != null ? this.getMaximum(p.right) : p;
    }

    private Node removeMinimum(Node p) {
        if (p.left == null) {
            return p.right;
        }
        p.left = this.removeMinimum(p.left);
        return this.balance(p);
    }

    private List<T> toList(Node p) {
        ArrayList<T> list = new ArrayList<T>();
        if (p.left != null) {
            list.addAll(this.toList(p.left));
        }
        list.add(p.key);
        if (p.right != null) {
            list.addAll(this.toList(p.right));
        }
        return list;
    }

    public AvlTree(Comparator<T> comparer) {
        this.comparer = comparer;
    }

    public int size() {
        return this.weight(this.root);
    }

    public T min() {
        Node p = this.getMinimum(this.root);
        if (p != null) {
            return p.key;
        }
        return null;
    }

    public T max() {
        Node p = this.getMaximum(this.root);
        if (p != null) {
            return p.key;
        }
        return null;
    }

    public int lowerBound(T k) {
        return this.lowerBound(this.root, k);
    }

    private int lowerBound(Node p, T k) {
        if (p == null) {
            return 0;
        }
        int cmp = this.comparer.compare(k, p.key);
        if (cmp <= 0) {
            return this.lowerBound(p.left, k);
        }
        return this.weight(p.left) + this.lowerBound(p.right, k) + 1;
    }

    public int upperBound(T k) {
        return this.upperBound(this.root, k);
    }

    private int upperBound(Node p, T k) {
        if (p == null) {
            return 0;
        }
        int cmp = this.comparer.compare(k, p.key);
        if (cmp < 0) {
            return this.upperBound(p.left, k);
        }
        return this.weight(p.left) + this.upperBound(p.right, k) + 1;
    }

    public int count(T k) {
        return this.count(this.root, k);
    }

    public T at(int k) {
        return this.at(this.root, k);
    }

    public void insert(T k) {
        this.root = this.insert(this.root, k);
    }

    private Node insert(Node p, T k) {
        if (p == null) {
            return this.createNewNode(k);
        }
        int cmp = this.comparer.compare(k, p.key);
        if (cmp < 0) {
            p.left = this.insert(p.left, k);
        } else {
            p.right = this.insert(p.right, k);
        }
        return this.balance(p);
    }

    public void remove(T k) {
        this.root = this.remove(this.root, k);
    }

    private Node remove(Node p, T k) {
        if (p == null) {
            return null;
        }
        int cmp = this.comparer.compare(k, p.key);
        if (cmp < 0) {
            p.left = this.remove(p.left, k);
        } else if (cmp > 0) {
            p.right = this.remove(p.right, k);
        } else {
            Node q = p.left;
            Node r = p.right;
            if (r == null) {
                return q;
            }
            Node min = this.getMinimum(r);
            min.right = this.removeMinimum(r);
            min.left = q;
            return this.balance(min);
        }
        return this.balance(p);
    }

    public void removeAt(int k) {
        T val = this.at(k);
        this.root = this.remove(this.root, val);
    }

    public List<T> toList() {
        if (this.root == null) {
            return new ArrayList();
        }
        return this.toList(this.root);
    }

    public class Node {
        public T key;
        public int weight;
        public int height;
        public Node left;
        public Node right;
    }
}

